/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamRecordDestroyedException;
import io.deepstream.IConnection;
import io.deepstream.Message;
import io.deepstream.MessageBuilder;
import io.deepstream.MessageParser;
import io.deepstream.RecordChangedCallback;
import io.deepstream.RecordEventsListener;
import io.deepstream.RecordMergeStrategies;
import io.deepstream.RecordMergeStrategy;
import io.deepstream.RecordMergeStrategyException;
import io.deepstream.RecordReadyListener;
import io.deepstream.UtilAckTimeoutRegistry;
import io.deepstream.UtilEmitter;
import io.deepstream.UtilJSONPath;
import io.deepstream.UtilResubscribeCallback;
import io.deepstream.UtilResubscribeNotifier;
import io.deepstream.constants.Actions;
import io.deepstream.constants.ConnectionState;
import io.deepstream.constants.Event;
import io.deepstream.constants.MergeStrategy;
import io.deepstream.constants.Topic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Record {
    private static final String ALL_EVENT = "ALL_EVENT";
    private static final String DESTROY_PENDING = "DESTROY_PENDING";
    private final UtilResubscribeNotifier utilResubscribeNotifier;
    private final UtilAckTimeoutRegistry ackTimeoutRegistry;
    private final IConnection connection;
    private final DeepstreamClientAbstract client;
    private final Gson gson;
    private final UtilJSONPath path;
    private final UtilEmitter subscribers;
    private final ArrayList<RecordEventsListener> recordEventsListeners;
    private final ArrayList<RecordReadyListener> recordReadyListeners;
    private final ArrayList<RecordDestroyPendingListener> recordDestroyPendingListeners;
    private final ArrayList<RecordReadyListener> onceRecordReadyListeners;
    private final String name;
    private final Map options;
    private boolean isReady;
    private boolean isDestroyed;
    private int version;
    private int usages;
    private RecordMergeStrategy mergeStrategy;
    private RecordRemoteUpdateHandler recordRemoteUpdateHandler;
    private JsonElement data;

    Record(String name, Map recordOptions, IConnection connection, Map options, DeepstreamClientAbstract client) {
        this.ackTimeoutRegistry = client.getAckTimeoutRegistry();
        this.name = name;
        this.options = options;
        this.usages = 0;
        this.version = -1;
        this.connection = connection;
        this.client = client;
        this.gson = new Gson();
        this.data = new JsonObject();
        this.path = new UtilJSONPath(this.data);
        this.subscribers = new UtilEmitter();
        this.isReady = false;
        this.isDestroyed = false;
        this.recordReadyListeners = new ArrayList();
        this.recordEventsListeners = new ArrayList();
        this.onceRecordReadyListeners = new ArrayList();
        this.recordDestroyPendingListeners = new ArrayList();
        this.scheduleAcks();
        this.sendRead();
        this.utilResubscribeNotifier = new UtilResubscribeNotifier(client, new UtilResubscribeCallback(){

            @Override
            public void resubscribe() {
                Record.this.sendRead();
            }
        });
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public int version() {
        return this.version;
    }

    public Record addRecordReadyListener(RecordReadyListener recordReadyListener) {
        this.recordReadyListeners.add(recordReadyListener);
        return this;
    }

    public Record removeRecordReadyListener(RecordReadyListener recordReadyListener) {
        this.recordReadyListeners.remove(recordReadyListener);
        return this;
    }

    public Record addRecordEventsListener(RecordEventsListener recordEventsListener) {
        this.recordEventsListeners.add(recordEventsListener);
        return this;
    }

    public Record removeRecordEventsListener(RecordEventsListener recordEventsListener) {
        this.recordEventsListeners.remove(recordEventsListener);
        return this;
    }

    public Record setMergeStrategy(MergeStrategy mergeStrategy) {
        this.mergeStrategy = RecordMergeStrategies.INSTANCE.getMergeStrategy(mergeStrategy);
        return this;
    }

    public Record setMergeStrategy(RecordMergeStrategy mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    <T> T get(Class<T> type) {
        return this.deepCopy(this.data, type);
    }

    public JsonElement get(String path) {
        return this.deepCopy(this.path.get(path));
    }

    public JsonElement get() {
        return this.deepCopy(this.data);
    }

    public Record set(Object value) throws DeepstreamRecordDestroyedException {
        return this.set(null, value, false);
    }

    public Record set(String path, Object value) throws DeepstreamRecordDestroyedException {
        return this.set(path, value, false);
    }

    public Record subscribe(String path, RecordChangedCallback recordChangedCallback) throws DeepstreamRecordDestroyedException {
        return this.subscribe(path, recordChangedCallback, false);
    }

    public Record subscribe(RecordChangedCallback recordChangedCallback) throws DeepstreamRecordDestroyedException {
        return this.subscribe(null, recordChangedCallback, false);
    }

    public Record subscribe(RecordChangedCallback recordChangedCallback, boolean triggerNow) throws DeepstreamRecordDestroyedException {
        this.subscribe(null, recordChangedCallback, triggerNow);
        return this;
    }

    public Record subscribe(String path, RecordChangedCallback recordChangedCallback, boolean triggerNow) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("subscribe");
        if (path == null) {
            this.subscribers.on(ALL_EVENT, (Object)recordChangedCallback);
        } else {
            this.subscribers.on(path, (Object)recordChangedCallback);
        }
        if (triggerNow && path == null) {
            recordChangedCallback.onRecordChanged(this.name, this.get());
        } else if (triggerNow) {
            recordChangedCallback.onRecordChanged(this.name, path, this.get(path));
        }
        return this;
    }

    public Record unsubscribe(RecordChangedCallback recordChangedCallback) throws DeepstreamRecordDestroyedException {
        this.unsubscribe(null, recordChangedCallback);
        return this;
    }

    public Record unsubscribe(String path, RecordChangedCallback recordChangedCallback) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("unsubscribe");
        if (path == null) {
            this.subscribers.off(ALL_EVENT, recordChangedCallback);
        } else {
            this.subscribers.off(path, recordChangedCallback);
        }
        return this;
    }

    public Record discard() throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("delete");
        --this.usages;
        if (this.usages <= 0) {
            this.whenReady(new RecordReadyListener(){

                @Override
                public void onRecordReady(String recordName, Record record) {
                    int subscriptionTimeout = Integer.parseInt((String)Record.this.options.get("subscriptionTimeout"));
                    Record.this.ackTimeoutRegistry.add(Topic.RECORD, Actions.UNSUBSCRIBE, Record.this.name, subscriptionTimeout);
                    Record.this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.UNSUBSCRIBE, Record.this.name));
                    for (RecordDestroyPendingListener recordDestroyPendingHandler : Record.this.recordDestroyPendingListeners) {
                        recordDestroyPendingHandler.onDestroyPending(Record.this.name);
                    }
                }
            });
        }
        return this;
    }

    public Record delete() throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("delete");
        this.whenReady(new RecordReadyListener(){

            @Override
            public void onRecordReady(String recordName, Record record) {
                int subscriptionTimeout = Integer.parseInt((String)Record.this.options.get("recordDeleteTimeout"));
                Record.this.ackTimeoutRegistry.add(Topic.RECORD, Actions.DELETE, Record.this.name, Event.DELETE_TIMEOUT, subscriptionTimeout);
                Record.this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.DELETE, Record.this.name));
                for (RecordDestroyPendingListener recordDestroyPendingHandler : Record.this.recordDestroyPendingListeners) {
                    recordDestroyPendingHandler.onDestroyPending(Record.this.name);
                }
            }
        });
        return this;
    }

    public Record whenReady(RecordReadyListener recordReadyListener) {
        if (this.isReady) {
            recordReadyListener.onRecordReady(this.name, this);
        } else {
            this.onceRecordReadyListeners.add(recordReadyListener);
        }
        return this;
    }

    protected void onMessage(Message message) {
        if (message.action == Actions.ACK) {
            this.processAckMessage(message);
        } else if (message.action == Actions.READ && this.version == -1) {
            this.onRead(message);
        } else if (message.action == Actions.READ || message.action == Actions.UPDATE || message.action == Actions.PATCH) {
            this.applyUpdate(message);
        } else if (message.data[0].equals(Event.VERSION_EXISTS.toString())) {
            this.recoverRecord(Integer.parseInt(message.data[2]), (JsonElement)this.gson.fromJson(message.data[3], JsonElement.class));
        } else if (message.data[0].equals(Event.MESSAGE_DENIED.toString())) {
            this.clearTimeouts();
        }
    }

    void setRecordRemoteUpdateHandler(RecordRemoteUpdateHandler recordRemoteUpdateHandler) {
        this.recordRemoteUpdateHandler = recordRemoteUpdateHandler;
    }

    private void applyUpdate(Message message) {
        int version = Integer.parseInt(message.data[1]);
        JsonElement data = message.action == Actions.PATCH ? this.gson.toJsonTree(MessageParser.convertTyped(message.data[3], this.client)) : (JsonElement)this.gson.fromJson(message.data[2], JsonElement.class);
        if (this.version != -1 && this.version + 1 != version) {
            if (message.action == Actions.PATCH) {
                this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.SNAPSHOT, this.name));
            } else {
                this.recoverRecord(version, data);
            }
            return;
        }
        if (this.recordRemoteUpdateHandler != null) {
            this.recordRemoteUpdateHandler.beforeRecordUpdate();
        }
        Map<String, JsonElement> oldValues = this.beginChange();
        this.version = version;
        if (Actions.PATCH == message.action) {
            this.path.set(message.data[2], data);
        } else {
            this.data = data;
            this.path.setCoreElement(data);
        }
        this.completeChange(oldValues);
        if (this.recordRemoteUpdateHandler != null) {
            this.recordRemoteUpdateHandler.afterRecordUpdate();
        }
    }

    private void recoverRecord(int remoteVersion, JsonElement remoteData) {
        try {
            JsonElement mergedData = this.mergeStrategy.merge(this, remoteData, remoteVersion);
            this.version = remoteVersion;
            this.set(null, mergedData, true);
        }
        catch (RecordMergeStrategyException ex) {
            this.client.onError(Topic.RECORD, Event.VERSION_EXISTS, "Received update for " + remoteVersion + " but version is " + this.version);
        }
    }

    private void scheduleAcks() {
        int readAckTimeout = Integer.parseInt((String)this.options.get("recordReadAckTimeout"));
        this.ackTimeoutRegistry.add(Topic.RECORD, Actions.SUBSCRIBE, this.name, Event.ACK_TIMEOUT, readAckTimeout);
        int readResponseTimeout = Integer.parseInt((String)this.options.get("recordReadTimeout"));
        this.ackTimeoutRegistry.add(Topic.RECORD, Actions.READ, this.name, Event.RESPONSE_TIMEOUT, readResponseTimeout);
    }

    private void clearTimeouts() {
        this.ackTimeoutRegistry.clear(Topic.RECORD, Actions.SUBSCRIBE, this.name);
        this.ackTimeoutRegistry.clear(Topic.RECORD, Actions.READ, this.name);
    }

    private Map<String, JsonElement> beginChange() {
        Set<String> paths = this.subscribers.getEvents();
        if (paths.isEmpty()) {
            return null;
        }
        HashMap<String, JsonElement> oldValues = new HashMap<String, JsonElement>();
        if (paths.contains(ALL_EVENT)) {
            oldValues.put(ALL_EVENT, this.get());
        }
        for (String path : paths) {
            if (path.equals(ALL_EVENT)) continue;
            oldValues.put(path, this.get(path));
        }
        return oldValues;
    }

    private void completeChange(Map<String, JsonElement> oldValues) {
        List<Object> listeners;
        if (oldValues == null || oldValues.isEmpty()) {
            return;
        }
        JsonElement oldValue = oldValues.remove(ALL_EVENT);
        if (oldValue != null && !oldValue.equals(this.data)) {
            listeners = this.subscribers.listeners(ALL_EVENT);
            for (Object listener : listeners) {
                ((RecordChangedCallback)listener).onRecordChanged(this.name, this.get());
            }
        }
        for (String key : oldValues.keySet()) {
            oldValue = oldValues.get(key);
            JsonElement newValue = this.get(key);
            if (oldValue != null && oldValue.equals(newValue)) continue;
            listeners = this.subscribers.listeners(key);
            for (Object listener : listeners) {
                ((RecordChangedCallback)listener).onRecordChanged(this.name, key, newValue);
            }
        }
    }

    private void throwExceptionIfDestroyed(String method) throws DeepstreamRecordDestroyedException {
        if (this.isDestroyed) {
            throw new DeepstreamRecordDestroyedException(method);
        }
    }

    private void processAckMessage(Message message) {
        Actions action = Actions.getAction(message.data[0]);
        this.ackTimeoutRegistry.clear(message);
        if (action.equals((Object)Actions.DELETE)) {
            for (RecordEventsListener recordEventsListener : this.recordEventsListeners) {
                recordEventsListener.onRecordDeleted(this.name);
            }
            this.destroy();
        } else if (action.equals((Object)Actions.UNSUBSCRIBE)) {
            for (RecordEventsListener recordEventsListener : this.recordEventsListeners) {
                recordEventsListener.onRecordDiscarded(this.name);
            }
            this.destroy();
        }
    }

    private void onRead(Message message) {
        this.ackTimeoutRegistry.clear(message);
        Map<String, JsonElement> oldValues = this.beginChange();
        this.version = Integer.parseInt(message.data[1]);
        this.data = (JsonElement)this.gson.fromJson(message.data[2], JsonElement.class);
        this.path.setCoreElement(this.data);
        this.completeChange(oldValues);
        this.setReady();
    }

    private void setReady() {
        this.isReady = true;
        for (RecordReadyListener recordReadyListener : this.onceRecordReadyListeners) {
            recordReadyListener.onRecordReady(this.name, this);
        }
        this.onceRecordReadyListeners.clear();
        for (RecordReadyListener recordReadyListener : this.recordReadyListeners) {
            recordReadyListener.onRecordReady(this.name, this);
        }
    }

    private void sendRead() {
        if (this.client.getConnectionState() == ConnectionState.OPEN) {
            this.connection.send(MessageBuilder.getMsg(Topic.RECORD, Actions.CREATEORREAD, this.name));
        }
    }

    private void sendUpdate(String key, Object value) {
        if (key == null || key.equals("")) {
            this.connection.sendMsg(Topic.RECORD, Actions.UPDATE, new String[]{this.name, String.valueOf(this.version), this.gson.toJson(value)});
        } else {
            this.connection.sendMsg(Topic.RECORD, Actions.PATCH, new String[]{this.name, String.valueOf(this.version), key, MessageBuilder.typed(value)});
        }
    }

    private void destroy() {
        this.clearTimeouts();
        this.utilResubscribeNotifier.destroy();
        this.isReady = false;
        this.isDestroyed = true;
    }

    private JsonElement deepCopy(JsonElement element) {
        try {
            return (JsonElement)this.gson.fromJson(this.gson.toJson((Object)element, JsonElement.class), JsonElement.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> T deepCopy(JsonElement element, Class<T> type) {
        return (T)this.gson.fromJson(this.gson.toJson((Object)element, JsonElement.class), type);
    }

    private Record set(String path, Object value, boolean force) throws DeepstreamRecordDestroyedException {
        this.throwExceptionIfDestroyed("set");
        JsonElement element = this.gson.toJsonTree(value);
        if (!this.isReady) {
            System.out.println("Not ready, should queue!");
            return this;
        }
        JsonElement object = this.path.get(path);
        if (!force) {
            if (object != null && object.equals(value)) {
                return this;
            }
            if (path == null && this.data.equals(value)) {
                return this;
            }
        }
        Map<String, JsonElement> oldValues = this.beginChange();
        ++this.version;
        this.path.set(path, element);
        this.data = this.path.getCoreElement();
        this.sendUpdate(path, value);
        this.completeChange(oldValues);
        return this;
    }

    void addRecordDestroyPendingListener(RecordDestroyPendingListener recordDestroyPendingListener) {
        this.recordDestroyPendingListeners.add(recordDestroyPendingListener);
    }

    void incrementUsage() {
        ++this.usages;
    }

    static interface RecordDestroyPendingListener {
        public void onDestroyPending(String var1);
    }

    static interface RecordRemoteUpdateHandler {
        public void beforeRecordUpdate();

        public void afterRecordUpdate();
    }
}

