/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import io.deepstream.Connection;
import io.deepstream.ConnectionStateListener;
import io.deepstream.DeepstreamClientAbstract;
import io.deepstream.DeepstreamLoginException;
import io.deepstream.DeepstreamRuntimeErrorHandler;
import io.deepstream.EventHandler;
import io.deepstream.LoginCallback;
import io.deepstream.RecordHandler;
import io.deepstream.RpcHandler;
import io.deepstream.constants.ConnectionState;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class DeepstreamClient
extends DeepstreamClientAbstract {
    private String uuid;
    private final Connection connection;
    public final RecordHandler record;
    public final EventHandler event;
    public final RpcHandler rpc;

    public DeepstreamClient(String url) throws URISyntaxException, IOException {
        this(url, new Properties());
    }

    public DeepstreamClient(String url, Properties options) throws URISyntaxException, IOException {
        Properties config = this.getConfig(options);
        this.connection = new Connection(url, config, this);
        this.event = new EventHandler(config, this.connection, this);
        this.rpc = new RpcHandler(config, this.connection, this);
        this.record = new RecordHandler(config, this.connection, this);
    }

    @Override
    public void setRuntimeErrorHandler(DeepstreamRuntimeErrorHandler deepstreamRuntimeErrorHandler) {
        super.setRuntimeErrorHandler(deepstreamRuntimeErrorHandler);
    }

    @Override
    public DeepstreamClient login(JsonElement authParams) throws DeepstreamLoginException {
        this.connection.authenticate(authParams, null);
        return this;
    }

    @Override
    public DeepstreamClient login(JsonElement authParams, LoginCallback loginCallback) throws DeepstreamLoginException {
        this.connection.authenticate(authParams, loginCallback);
        return this;
    }

    @Override
    public DeepstreamClient close() {
        this.connection.close();
        return this;
    }

    @Override
    public DeepstreamClient addConnectionChangeListener(ConnectionStateListener connectionStateListener) {
        this.connection.addConnectionChangeListener(connectionStateListener);
        return this;
    }

    @Override
    public DeepstreamClient removeConnectionChangeListener(ConnectionStateListener connectionStateListener) {
        this.connection.removeConnectionChangeListener(connectionStateListener);
        return this;
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connection.getConnectionState();
    }

    @Override
    public String getUid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
            return this.uuid;
        }
        return this.uuid;
    }

    private Properties getConfig(Properties properties) throws IOException {
        Properties config = new Properties();
        FileInputStream in = new FileInputStream("DefaultConfig.properties");
        config.load(in);
        config.putAll((Map<?, ?>)properties);
        in.close();
        return config;
    }
}

