/*
 * Decompiled with CFR 0.152.
 */
package io.deepstream;

import com.google.gson.JsonElement;
import io.deepstream.AnonymousRecordNameChangedListener;
import io.deepstream.AnonymousRecordReadyListener;
import io.deepstream.AnonymousRecordUninitialized;
import io.deepstream.Record;
import io.deepstream.RecordChangedCallback;
import io.deepstream.RecordEventsListener;
import io.deepstream.RecordHandler;
import io.deepstream.RecordReadyListener;
import java.util.ArrayList;

public class AnonymousRecord {
    public String name;
    private final RecordListeners recordListeners;
    private final ArrayList<Subscription> subscriptions;
    private final ArrayList<AnonymousRecordNameChangedListener> anonymousRecordNameChangedCallbacks;
    private final RecordHandler recordHandler;
    private final ArrayList<AnonymousRecordReadyListener> recordReadyListeners;
    private Record record;

    AnonymousRecord(RecordHandler recordHandler) {
        this.recordHandler = recordHandler;
        this.subscriptions = new ArrayList();
        this.anonymousRecordNameChangedCallbacks = new ArrayList();
        this.recordReadyListeners = new ArrayList();
        this.recordListeners = new RecordListeners(this);
    }

    public AnonymousRecord addRecordReadyListener(AnonymousRecordReadyListener recordReadyListener) {
        this.recordReadyListeners.add(recordReadyListener);
        return this;
    }

    public AnonymousRecord removeRecordReadyListener(AnonymousRecordReadyListener recordEventsListener) {
        this.recordReadyListeners.remove(recordEventsListener);
        return this;
    }

    public AnonymousRecord addRecordNameChangedListener(AnonymousRecordNameChangedListener anonymousRecordNameChangedCallback) {
        this.anonymousRecordNameChangedCallbacks.add(anonymousRecordNameChangedCallback);
        return this;
    }

    public AnonymousRecord removeRecordNameChangedCallback(AnonymousRecordNameChangedListener anonymousRecordNameChangedCallback) {
        this.anonymousRecordNameChangedCallbacks.remove(anonymousRecordNameChangedCallback);
        return this;
    }

    public AnonymousRecord set(Object data) throws AnonymousRecordUninitialized {
        return this.set(null, data);
    }

    public AnonymousRecord set(String path, Object data) throws AnonymousRecordUninitialized {
        if (this.record == null) {
            throw new AnonymousRecordUninitialized("set");
        }
        this.record.set(path, data);
        return this;
    }

    public AnonymousRecord discard() throws AnonymousRecordUninitialized {
        if (this.record == null) {
            throw new AnonymousRecordUninitialized("discard");
        }
        this.record.discard();
        return this;
    }

    public AnonymousRecord delete() throws AnonymousRecordUninitialized {
        if (this.record == null) {
            throw new AnonymousRecordUninitialized("delete");
        }
        this.record.delete();
        return this;
    }

    public JsonElement get() {
        if (this.record == null) {
            return null;
        }
        return this.record.get();
    }

    public JsonElement get(String path) {
        if (this.record == null) {
            return null;
        }
        return this.record.get(path);
    }

    public AnonymousRecord subscribe(RecordChangedCallback recordChangedCallback) {
        return this.subscribe(null, recordChangedCallback);
    }

    public AnonymousRecord subscribe(String path, RecordChangedCallback recordChangedCallback) {
        this.subscriptions.add(new Subscription(path, recordChangedCallback));
        if (this.record != null) {
            this.record.subscribe(path, recordChangedCallback, true);
        }
        return this;
    }

    public AnonymousRecord unsubscribe(RecordChangedCallback recordChangedCallback) {
        return this.unsubscribe(null, recordChangedCallback);
    }

    public AnonymousRecord unsubscribe(String path, RecordChangedCallback recordChangedCallback) {
        this.subscriptions.remove(new Subscription(path, recordChangedCallback));
        for (Subscription subscription : this.subscriptions) {
            if (!subscription.path.equals(path) || subscription.recordChangedCallback != recordChangedCallback) continue;
            this.subscriptions.remove(subscription);
        }
        if (this.record != null) {
            this.record.unsubscribe(path, recordChangedCallback);
        }
        return this;
    }

    public AnonymousRecord addRecordEventsListener(RecordEventsListener recordEventListener) {
        this.subscriptions.add(new Subscription(recordEventListener));
        if (this.record != null) {
            this.record.addRecordEventsListener(recordEventListener);
        }
        return this;
    }

    public AnonymousRecord removeRecordEventsListener(RecordEventsListener recordEventListener) {
        for (Subscription subscription : this.subscriptions) {
            if (subscription.recordChangedCallback == null) continue;
            this.subscriptions.remove(subscription);
        }
        if (this.record != null) {
            this.record.removeRecordEventsListener(recordEventListener);
        }
        return this;
    }

    public AnonymousRecord setName(String recordName) {
        this.name = recordName;
        this.unsubscribeRecord();
        this.record = this.recordHandler.getRecord(recordName);
        this.subscribeRecord();
        if (this.record.isReady()) {
            this.recordListeners.onRecordReady(this.name, this.record);
        }
        for (AnonymousRecordNameChangedListener anonymousRecordNameChangedCallback : this.anonymousRecordNameChangedCallbacks) {
            anonymousRecordNameChangedCallback.recordNameChanged(recordName, this);
        }
        return this;
    }

    private void subscribeRecord() {
        for (Subscription subscription : this.subscriptions) {
            if (subscription.recordChangedCallback == null) continue;
            this.record.subscribe(subscription.path, subscription.recordChangedCallback, true);
        }
        this.record.addRecordReadyListener(this.recordListeners);
    }

    private void unsubscribeRecord() {
        if (this.record == null || this.record.isDestroyed()) {
            return;
        }
        for (Subscription subscription : this.subscriptions) {
            if (subscription.recordChangedCallback == null) continue;
            this.record.unsubscribe(subscription.path, subscription.recordChangedCallback);
        }
        this.record.removeRecordReadyListener(this.recordListeners);
        this.record.discard();
    }

    private class RecordListeners
    implements RecordReadyListener {
        private final AnonymousRecord anonymousRecord;

        RecordListeners(AnonymousRecord anonymousRecord2) {
            this.anonymousRecord = anonymousRecord2;
        }

        @Override
        public void onRecordReady(String recordName, Record record) {
            for (AnonymousRecordReadyListener anonymousRecordReadyListener : this.anonymousRecord.recordReadyListeners) {
                anonymousRecordReadyListener.onRecordReady(recordName, this.anonymousRecord);
            }
        }
    }

    private class Subscription {
        String path;
        RecordChangedCallback recordChangedCallback;
        RecordEventsListener recordEventsListener;

        Subscription(String path, RecordChangedCallback recordChangedCallback) {
            this.path = path;
            this.recordChangedCallback = recordChangedCallback;
        }

        Subscription(RecordEventsListener recordEventsListener) {
            this.recordEventsListener = recordEventsListener;
        }
    }
}

