/*
 * Decompiled with CFR 0.152.
 */
package io.ddavison.selenium;

import com.google.common.base.Strings;
import io.ddavison.selenium.Config;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.ui.Select;

public class AutomationTest {
    public WebDriver driver;
    private final int MAX_ATTEMPTS = 5;
    private int attempts = 0;
    public Actions actions;
    public Map<String, By> props = new HashMap<String, By>();
    private Map<String, String> vars = new HashMap<String, String>();
    private String baseUrl;
    private Pattern p;
    private Matcher m;

    public AutomationTest() {
        DesiredCapabilities capabilities;
        Config configuration = this.getClass().getAnnotation(Config.class);
        this.baseUrl = configuration.url();
        boolean isLocal = StringUtils.isEmpty((CharSequence)configuration.hub());
        switch (configuration.browser()) {
            case CHROME: {
                capabilities = DesiredCapabilities.chrome();
                if (!isLocal) break;
                this.driver = new ChromeDriver((Capabilities)capabilities);
                break;
            }
            case FIREFOX: {
                capabilities = DesiredCapabilities.firefox();
                if (!isLocal) break;
                this.driver = new FirefoxDriver((Capabilities)capabilities);
                break;
            }
            case INTERNET_EXPLORER: {
                capabilities = DesiredCapabilities.internetExplorer();
                if (!isLocal) break;
                this.driver = new InternetExplorerDriver((Capabilities)capabilities);
                break;
            }
            case SAFARI: {
                capabilities = DesiredCapabilities.safari();
                if (!isLocal) break;
                this.driver = new SafariDriver((Capabilities)capabilities);
                break;
            }
            case HTMLUNIT: {
                capabilities = DesiredCapabilities.htmlUnitWithJs();
                if (!isLocal) break;
                this.driver = new HtmlUnitDriver((Capabilities)capabilities);
                break;
            }
            default: {
                System.err.println("Unknown browser: " + (Object)((Object)configuration.browser()));
                return;
            }
        }
        if (!isLocal) {
            try {
                this.driver = new RemoteWebDriver(new URL(configuration.hub()), (Capabilities)capabilities);
            }
            catch (Exception x) {
                System.err.println("Couldn't connect to hub: " + configuration.hub());
                return;
            }
        }
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream(this.getClass().getSimpleName().concat(".properties")));
            for (String key : properties.stringPropertyNames()) {
                this.props.put(key, By.cssSelector((String)properties.getProperty(key)));
            }
        }
        catch (Exception x) {
            System.err.println("WARN: No css properties file for this test was found.  You can create one under /src/tests/resources/<package(s)>/" + this.getClass().getSimpleName().concat(".properties"));
        }
        this.actions = new Actions(this.driver);
        this.driver.navigate().to(this.baseUrl);
    }

    public static String findFile(String filename) {
        String[] paths;
        for (String path : paths = new String[]{"", "bin/", "target/classes"}) {
            if (!new File(path + filename).exists()) continue;
            return path + filename;
        }
        return null;
    }

    @After
    public void teardown() {
        this.driver.quit();
    }

    public WebElement waitForElement(By by) {
        int attempts = 0;
        int size = this.driver.findElements(by).size();
        while (size == 0) {
            size = this.driver.findElements(by).size();
            if (attempts == 5) {
                Assert.fail((String)String.format("Could not find %s after %d seconds", by.toString(), 5));
            }
            ++attempts;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception x) {
                Assert.fail((String)"Failed due to an exception during Thread.sleep!");
                x.printStackTrace();
            }
        }
        if (size > 1) {
            System.err.println("WARN: There are more than 1 " + by.toString() + " 's!");
        }
        return this.driver.findElement(by);
    }

    public AutomationTest click(String css) {
        return this.click(By.cssSelector((String)css));
    }

    public AutomationTest click(By by) {
        this.waitForElement(by).click();
        return this;
    }

    public AutomationTest setText(String css, String text) {
        return this.setText(By.cssSelector((String)css), text);
    }

    public AutomationTest setText(By by, String text) {
        WebElement element = this.waitForElement(by);
        element.clear();
        element.sendKeys(new CharSequence[]{text});
        return this;
    }

    public AutomationTest hoverOver(String css) {
        return this.hoverOver(By.cssSelector((String)css));
    }

    public AutomationTest hoverOver(By by) {
        this.actions.moveToElement(this.driver.findElement(by)).perform();
        return this;
    }

    public boolean isChecked(String css) {
        return this.isChecked(By.cssSelector((String)css));
    }

    public boolean isChecked(By by) {
        return this.waitForElement(by).isSelected();
    }

    public boolean isPresent(String css) {
        return this.isPresent(By.cssSelector((String)css));
    }

    public boolean isPresent(By by) {
        return this.driver.findElements(by).size() > 0;
    }

    public String getText(String css) {
        return this.getText(By.cssSelector((String)css));
    }

    public String getText(By by) {
        WebElement e = this.waitForElement(by);
        String text = e.getTagName().equalsIgnoreCase("input") || e.getTagName().equalsIgnoreCase("select") ? e.getAttribute("value") : e.getText();
        return text;
    }

    public String getAttribute(String css, String attribute) {
        return this.getAttribute(By.cssSelector((String)css), attribute);
    }

    public String getAttribute(By by, String attribute) {
        return this.waitForElement(by).getAttribute(attribute);
    }

    public AutomationTest check(String css) {
        return this.check(By.cssSelector((String)css));
    }

    public AutomationTest check(By by) {
        if (!this.isChecked(by)) {
            this.waitForElement(by).click();
            Assert.assertTrue((String)(by.toString() + " did not check!"), (boolean)this.isChecked(by));
        }
        return this;
    }

    public AutomationTest uncheck(String css) {
        return this.uncheck(By.cssSelector((String)css));
    }

    public AutomationTest uncheck(By by) {
        if (this.isChecked(by)) {
            this.waitForElement(by).click();
            Assert.assertFalse((String)(by.toString() + " did not uncheck!"), (boolean)this.isChecked(by));
        }
        return this;
    }

    public AutomationTest selectOptionByText(String css, String text) {
        return this.selectOptionByText(By.cssSelector((String)css), text);
    }

    public AutomationTest selectOptionByText(By by, String text) {
        Select box = new Select(this.waitForElement(by));
        box.selectByVisibleText(text);
        return this;
    }

    public AutomationTest selectOptionByValue(String css, String value) {
        return this.selectOptionByValue(By.cssSelector((String)css), value);
    }

    public AutomationTest selectOptionByValue(By by, String value) {
        Select box = new Select(this.waitForElement(by));
        box.selectByValue(value);
        return this;
    }

    public AutomationTest waitForWindow(String regex) {
        Set windows = this.driver.getWindowHandles();
        for (String window : windows) {
            try {
                this.driver.switchTo().window(window);
                this.p = Pattern.compile(regex);
                this.m = this.p.matcher(this.driver.getCurrentUrl());
                if (this.m.find()) {
                    this.attempts = 0;
                    return this.switchToWindow(regex);
                }
                this.m = this.p.matcher(this.driver.getTitle());
                if (!this.m.find()) continue;
                this.attempts = 0;
                return this.switchToWindow(regex);
            }
            catch (NoSuchWindowException e) {
                if (this.attempts <= 5) {
                    ++this.attempts;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    return this.waitForWindow(regex);
                }
                Assert.fail((String)("Window with url|title: " + regex + " did not appear after " + 5 + " tries. Exiting."));
            }
        }
        if (this.attempts == 5) {
            Assert.fail((String)("Window with title: " + regex + " did not appear after 5 tries. Exiting."));
            return this;
        }
        System.out.println("#waitForWindow() : Window doesn't exist yet. [" + regex + "] Trying again. " + this.attempts + "/" + 5);
        ++this.attempts;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return this.waitForWindow(regex);
    }

    public AutomationTest switchToWindow(String regex) {
        Set windows = this.driver.getWindowHandles();
        for (String window : windows) {
            this.driver.switchTo().window(window);
            System.out.println(String.format("#switchToWindow() : title=%s ; url=%s", this.driver.getTitle(), this.driver.getCurrentUrl()));
            this.p = Pattern.compile(regex);
            this.m = this.p.matcher(this.driver.getTitle());
            if (this.m.find()) {
                return this;
            }
            this.m = this.p.matcher(this.driver.getCurrentUrl());
            if (!this.m.find()) continue;
            return this;
        }
        Assert.fail((String)("Could not switch to window with title / url: " + regex));
        return this;
    }

    public AutomationTest closeWindow(String regex) {
        if (regex == null) {
            this.driver.close();
            if (this.driver.getWindowHandles().size() == 1) {
                this.driver.switchTo().window((String)this.driver.getWindowHandles().iterator().next());
            }
            return this;
        }
        Set windows = this.driver.getWindowHandles();
        for (String window : windows) {
            try {
                this.driver.switchTo().window(window);
                this.p = Pattern.compile(regex);
                this.m = this.p.matcher(this.driver.getTitle());
                if (this.m.find()) {
                    this.switchToWindow(regex);
                    this.driver.close();
                    if (windows.size() != 2) continue;
                    this.driver.switchTo().window((String)windows.iterator().next());
                    continue;
                }
                this.m = this.p.matcher(this.driver.getCurrentUrl());
                if (!this.m.find()) continue;
                this.switchToWindow(regex);
                this.driver.close();
                if (windows.size() != 2) continue;
                this.driver.switchTo().window((String)windows.iterator().next());
            }
            catch (NoSuchWindowException e) {
                Assert.fail((String)("Cannot close a window that doesn't exist. [" + regex + "]"));
            }
        }
        return this;
    }

    public AutomationTest closeWindow() {
        return this.closeWindow(null);
    }

    public AutomationTest switchToFrame(String idOrName) {
        try {
            this.driver.switchTo().frame(idOrName);
        }
        catch (Exception x) {
            Assert.fail((String)("Couldn't switch to frame with id or name [" + idOrName + "]"));
        }
        return this;
    }

    public AutomationTest switchToDefaultContent() {
        this.driver.switchTo().defaultContent();
        return this;
    }

    public AutomationTest validatePresent(String css) {
        return this.validatePresent(By.cssSelector((String)css));
    }

    public AutomationTest validatePresent(By by) {
        this.waitForElement(by);
        Assert.assertTrue((String)("Element " + by.toString() + " does not exist!"), (boolean)this.isPresent(by));
        return this;
    }

    public AutomationTest validateNotPresent(String css) {
        return this.validateNotPresent(By.cssSelector((String)css));
    }

    public AutomationTest validateNotPresent(By by) {
        Assert.assertFalse((String)("Element " + by.toString() + " exists!"), (boolean)this.isPresent(by));
        return this;
    }

    public AutomationTest validateText(String css, String text) {
        return this.validateText(By.cssSelector((String)css), text);
    }

    public AutomationTest validateText(By by, String text) {
        String actual = this.getText(by);
        Assert.assertTrue((String)String.format("Text does not match! [expected: %s] [actual: %s]", text, actual), (boolean)text.equals(actual));
        return this;
    }

    public AutomationTest validateTextNot(String css, String text) {
        return this.validateTextNot(By.cssSelector((String)css), text);
    }

    public AutomationTest validateTextNot(By by, String text) {
        String actual = this.getText(by);
        Assert.assertFalse((String)String.format("Text matches! [expected: %s] [actual: %s]", text, actual), (boolean)text.equals(actual));
        return this;
    }

    public AutomationTest validateTextPresent(String text) {
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(text));
        return this;
    }

    public AutomationTest validateTextNotPresent(String text) {
        Assert.assertFalse((boolean)this.driver.getPageSource().contains(text));
        return this;
    }

    public AutomationTest validateChecked(String css) {
        return this.validateChecked(By.cssSelector((String)css));
    }

    public AutomationTest validateChecked(By by) {
        Assert.assertTrue((String)(by.toString() + " is not checked!"), (boolean)this.isChecked(by));
        return this;
    }

    public AutomationTest validateUnchecked(String css) {
        return this.validateUnchecked(By.cssSelector((String)css));
    }

    public AutomationTest validateUnchecked(By by) {
        Assert.assertFalse((String)(by.toString() + " is not unchecked!"), (boolean)this.isChecked(by));
        return this;
    }

    public AutomationTest validateAttribute(String css, String attr, String regex) {
        return this.validateAttribute(By.cssSelector((String)css), attr, regex);
    }

    public AutomationTest validateAttribute(By by, String attr, String regex) {
        String actual = null;
        try {
            actual = this.driver.findElement(by).getAttribute(attr);
            if (actual.equals(regex)) {
                return this;
            }
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)("No such element [" + by.toString() + "] exists."));
        }
        catch (Exception x) {
            Assert.fail((String)"Cannot validate an attribute if an element doesn't have it!");
        }
        this.p = Pattern.compile(regex);
        this.m = this.p.matcher(actual);
        Assert.assertTrue((String)String.format("Attribute doesn't match! [Selector: %s] [Attribute: %s] [Desired value: %s] [Actual value: %s]", by.toString(), attr, regex, actual), (boolean)this.m.find());
        return this;
    }

    public AutomationTest validateUrl(String regex) {
        this.p = Pattern.compile(regex);
        this.m = this.p.matcher(this.driver.getCurrentUrl());
        Assert.assertTrue((String)("Url does not match regex [" + regex + "] (actual is: \"" + this.driver.getCurrentUrl() + "\")"), (boolean)this.m.find());
        return this;
    }

    public AutomationTest validateTrue(boolean condition) {
        Assert.assertTrue((boolean)condition);
        return this;
    }

    public AutomationTest validateFalse(boolean condition) {
        Assert.assertFalse((boolean)condition);
        return this;
    }

    public AutomationTest goBack() {
        this.driver.navigate().back();
        return this;
    }

    public AutomationTest navigateTo(String url) {
        if (url.contains("://")) {
            this.driver.navigate().to(url);
        } else if (url.startsWith("/")) {
            this.driver.navigate().to(this.baseUrl.concat(url));
        } else {
            this.driver.navigate().to(this.driver.getCurrentUrl().concat(url));
        }
        return this;
    }

    public AutomationTest store(String key, String value) {
        this.vars.put(key, value);
        return this;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        if (Strings.isNullOrEmpty((String)this.vars.get(key))) {
            return defaultValue;
        }
        return this.vars.get(key);
    }

    public AutomationTest log(Object object) {
        System.out.println(object);
        return this;
    }

    static {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            System.setProperty("webdriver.chrome.driver", AutomationTest.findFile("chromedriver"));
        } else {
            System.setProperty("webdriver.chrome.driver", AutomationTest.findFile("chromedriver.exe"));
        }
    }
}

