/*
 * Decompiled with CFR 0.152.
 */
package io.daten.faster.memory;

import io.daten.faster.PlatformUtil;
import io.daten.faster.UnsafeUtil;
import sun.misc.Unsafe;

public final class FasterByteComparison {
    private static final Unsafe UNSAFE = UnsafeUtil.getTheUnsafe();

    private FasterByteComparison() {
    }

    public static int compare(byte[] buffer1, byte[] buffer2) {
        return FasterByteComparison.compare(buffer1, 0, buffer1.length, buffer2, 0, buffer2.length);
    }

    public static int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        int i;
        int minLength = Math.min(length1, length2);
        int fullWordBytes = minLength & 0xFFFFFFF8;
        int memPos1 = offset1 + UnsafeUtil.BYTE_ARRAY_OFFSET;
        int memPos2 = offset2 + UnsafeUtil.BYTE_ARRAY_OFFSET;
        for (i = 0; i < fullWordBytes; i += 8) {
            long right;
            long left = UNSAFE.getLong(buffer1, (long)memPos1 + (long)i);
            if (left == (right = UNSAFE.getLong(buffer2, (long)memPos2 + (long)i))) continue;
            if (PlatformUtil.IS_LITTLE_ENDIAN) {
                return Long.compareUnsigned(Long.reverseBytes(left), Long.reverseBytes(right));
            }
            return Long.compareUnsigned(left, right);
        }
        for (i = fullWordBytes; i < minLength; ++i) {
            int result = Long.compareUnsigned(buffer1[offset1 + i], buffer2[offset2 + i]);
            if (result == 0) continue;
            return result;
        }
        return length1 - length2;
    }
}

