/*
 * Decompiled with CFR 0.152.
 */
package io.daten.faster.collections;

public final class FasterLongList {
    private int count;
    private long[] data;

    FasterLongList(int size) {
        this.data = new long[size];
        this.count = 0;
    }

    public void add(long num) {
        this.ensureCapacity(this.count + 1);
        this.data[this.count++] = num;
    }

    public long get(int index) {
        return this.data[index];
    }

    public void set(int index, long value) {
        int minCount = index + 1;
        this.ensureCapacity(minCount);
        this.data[index] = value;
        this.count = Math.max(minCount, this.count);
    }

    public int size() {
        return this.count;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length < capacity) {
            long[] old = this.data;
            this.data = new long[Math.max(capacity, (this.data.length << 1) + 1)];
            System.arraycopy(old, 0, this.data, 0, old.length);
        }
    }
}

