/*
 * Decompiled with CFR 0.152.
 */
package io.daten.faster.collections;

public final class FasterIntList {
    private int count;
    private int[] data;

    FasterIntList(int size) {
        this.data = new int[size];
        this.count = 0;
    }

    public void add(int num) {
        this.ensureCapacity(this.count + 1);
        this.data[this.count++] = num;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        int minCount = index + 1;
        this.ensureCapacity(minCount);
        this.data[index] = value;
        this.count = Math.max(minCount, this.count);
    }

    public int size() {
        return this.count;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length < capacity) {
            int[] old = this.data;
            this.data = new int[Math.max(capacity, (this.data.length << 1) + 1)];
            System.arraycopy(old, 0, this.data, 0, old.length);
        }
    }
}

