/*
 * Decompiled with CFR 0.152.
 */
package io.datalbry.precise.processor.kotlin.extension;

import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeReference;
import io.datalbry.precise.processor.kotlin.extension.KSDeclarationExtensionsKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0010\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0010\u001a\u0012\u0010\u0014\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0013*\u00020\u0010\u001a\n\u0010\u0018\u001a\u00020\u0013*\u00020\u0010\u001a\n\u0010\u0019\u001a\u00020\u0013*\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\"\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"ARRAY_DECLARATION_NAME", "", "COLLECTION_DECLARATION", "OPTIONAL_DECLARATION_NAME", "OPTIONAL_DECLARATION_PACKAGE", "PRIMITIVE_ARRAY_TYPES", "", "getPRIMITIVE_ARRAY_TYPES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "PRIMITIVE_ARRAY_TYPES_MAPPING", "", "getPRIMITIVE_ARRAY_TYPES_MAPPING", "()Ljava/util/Map;", "getInnerType", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;", "getInnerTypeNameOfPrimitiveArray", "isArray", "", "isCollection", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "isNullable", "isOptional", "isPrimitiveArray", "processor-kotlin"})
public final class KSPropertyDeclarationExtensionsKt {
    @NotNull
    private static final String[] PRIMITIVE_ARRAY_TYPES = new String[]{"IntArray", "ByteArray", "CharArray", "ShortArray", "LongArray", "FloatArray", "DoubleArray", "BooleanArray"};
    @NotNull
    private static final Map<String, String> PRIMITIVE_ARRAY_TYPES_MAPPING = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"IntArray", (Object)"int"), TuplesKt.to((Object)"ByteArray", (Object)"byte"), TuplesKt.to((Object)"CharArray", (Object)"char"), TuplesKt.to((Object)"ShortArray", (Object)"int"), TuplesKt.to((Object)"LongArray", (Object)"long"), TuplesKt.to((Object)"FloatArray", (Object)"float"), TuplesKt.to((Object)"DoubleArray", (Object)"double"), TuplesKt.to((Object)"BooleanArray", (Object)"boolean")});
    @NotNull
    public static final String ARRAY_DECLARATION_NAME = "Array";
    @NotNull
    public static final String OPTIONAL_DECLARATION_NAME = "Optional";
    @NotNull
    public static final String OPTIONAL_DECLARATION_PACKAGE = "java.util";
    @NotNull
    public static final String COLLECTION_DECLARATION = "kotlin.collections.Collection";

    @NotNull
    public static final String[] getPRIMITIVE_ARRAY_TYPES() {
        return PRIMITIVE_ARRAY_TYPES;
    }

    @NotNull
    public static final Map<String, String> getPRIMITIVE_ARRAY_TYPES_MAPPING() {
        return PRIMITIVE_ARRAY_TYPES_MAPPING;
    }

    public static final boolean isArray(@NotNull KSPropertyDeclaration $this$isArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isArray, (String)"$this$isArray");
        return Intrinsics.areEqual((Object)$this$isArray.getType().resolve().getDeclaration().getSimpleName().asString(), (Object)ARRAY_DECLARATION_NAME);
    }

    @NotNull
    public static final KSDeclaration getInnerType(@NotNull KSPropertyDeclaration $this$getInnerType) {
        Intrinsics.checkNotNullParameter((Object)$this$getInnerType, (String)"$this$getInnerType");
        List arguments = $this$getInnerType.getType().resolve().getArguments();
        boolean bl = arguments.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KSTypeReference kSTypeReference = ((KSTypeArgument)arguments.get(0)).getType();
        Intrinsics.checkNotNull((Object)kSTypeReference);
        return kSTypeReference.resolve().getDeclaration();
    }

    public static final boolean isPrimitiveArray(@NotNull KSPropertyDeclaration $this$isPrimitiveArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"$this$isPrimitiveArray");
        String type = $this$isPrimitiveArray.getType().resolve().getDeclaration().getSimpleName().asString();
        return ArraysKt.contains((Object[])PRIMITIVE_ARRAY_TYPES, (Object)type);
    }

    @NotNull
    public static final String getInnerTypeNameOfPrimitiveArray(@NotNull KSPropertyDeclaration $this$getInnerTypeNameOfPrimitiveArray) {
        Intrinsics.checkNotNullParameter((Object)$this$getInnerTypeNameOfPrimitiveArray, (String)"$this$getInnerTypeNameOfPrimitiveArray");
        String type = $this$getInnerTypeNameOfPrimitiveArray.getType().resolve().getDeclaration().getSimpleName().asString();
        String string = PRIMITIVE_ARRAY_TYPES_MAPPING.get(type);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static final boolean isOptional(@NotNull KSPropertyDeclaration $this$isOptional) {
        Intrinsics.checkNotNullParameter((Object)$this$isOptional, (String)"$this$isOptional");
        KSDeclaration declaration = $this$isOptional.getType().resolve().getDeclaration();
        return KSDeclarationExtensionsKt.hasName(declaration, OPTIONAL_DECLARATION_NAME) && KSDeclarationExtensionsKt.hasPackage(declaration, OPTIONAL_DECLARATION_PACKAGE);
    }

    public static final boolean isCollection(@NotNull KSPropertyDeclaration $this$isCollection, @NotNull Resolver resolver) {
        KSClassDeclaration collectionDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$isCollection, (String)"$this$isCollection");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        KSName ksName = resolver.getKSNameFromString(COLLECTION_DECLARATION);
        KSClassDeclaration kSClassDeclaration = collectionDeclaration = resolver.getClassDeclarationByName(ksName);
        Intrinsics.checkNotNull((Object)kSClassDeclaration);
        return kSClassDeclaration.asStarProjectedType().isAssignableFrom($this$isCollection.getType().resolve());
    }

    public static final boolean isNullable(@NotNull KSPropertyDeclaration $this$isNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNullable, (String)"$this$isNullable");
        return $this$isNullable.getType().resolve().isMarkedNullable();
    }
}

