package io.datalbry.confluence.cloud.client.feign.space

import feign.Param
import feign.QueryMap
import feign.RequestLine
import io.datalbry.confluence.cloud.client.model.Paginated
import io.datalbry.confluence.cloud.client.model.space.Space
import io.datalbry.confluence.cloud.client.model.space.SpaceKey
import io.datalbry.confluence.cloud.client.model.space.SpacePermissions

/**
 * Feign interface to access the Space resource
 *
 * TODO: KDoc
 *
 * @author timo gruen - 2021-01-07
 */
interface FeignSpaceResource {

    @RequestLine("GET /wiki/rest/api/space/{spaceKey}")
    fun getSpace(
        @Param("spaceKey") spaceKey: String,
        @QueryMap queryMap: Map<String, String> = spaceQuery()
    ): Space

    @RequestLine("GET /wiki/rest/api/space$SPACE_KEY_QUERY")
    fun getSpaceKeys(
        @Param("limit") limit: Int,
        @Param("start") start: Int
    ): Paginated<SpaceKey>

    @RequestLine("GET /wiki/rest/api/space/{spaceKey}")
    fun getPermission(
        @Param("spaceKey") spaceKey: String,
        @QueryMap queryMap: Map<String, String> = permissionQuery()
    ): SpacePermissions

    private fun spaceQuery() = mapOf("expand" to SPACE_EXPANDS)
    private fun permissionQuery() = mapOf("expand" to SPACE_PERMISSION_EXPANDS)

    companion object {
        const val SPACE_EXPANDS: String = "icon,metadata.labels,identifiers,description.plain," +
                "description.view,history,homepage.childTypes.all"
        const val SPACE_PERMISSION_EXPANDS: String = "permissions"
        const val SPACE_KEY_QUERY: String = "?limit={limit}&start={start}"
    }
}
