package io.datalbry.confluence.cloud.client.feign.space

import io.datalbry.confluence.cloud.client.model.ACL
import io.datalbry.confluence.cloud.client.SpaceClient
import io.datalbry.confluence.cloud.client.feign.iterator.PaginatedIterator
import io.datalbry.confluence.cloud.client.model.space.Space
import io.datalbry.confluence.cloud.client.model.space.SpaceKey

/**
 * [SpaceClient] implementation backed by Feign.
 *
 * @param feign resource to access everything [Space] related
 *
 * @author timo gruen - 2021-01-06
 */
class FeignSpaceClient(private val feign: FeignSpaceResource): SpaceClient {

    override fun getSpace(spaceKey: SpaceKey): Space {
        return feign.getSpace(spaceKey.key)
    }

    override fun getSpaceKeys(pageSize: Int): Iterator<SpaceKey> {
        val page = feign.getSpaceKeys(start = 0, limit = pageSize)
        return PaginatedIterator(page) { feign.getSpaceKeys(pageSize, it.start + it.size) }
    }

    override fun getRestrictions(spaceKey: SpaceKey, pageSize: Int): ACL {
        val permission = feign.getPermission(spaceKey.key)
        val readPermission = permission
            .permissions
            .first { it.operation.operation == "read" && it.operation.targetType == "space" }

        val user = readPermission.subjects.user.results
        val group = readPermission.subjects.group.results
        return ACL(user.iterator(), group.iterator())
    }
}
