package io.datalbry.confluence.cloud.client.feign.iterator

import io.datalbry.confluence.cloud.client.model.Paginated

/**
 * Iterator which is able to paginate through a resource set
 *
 * @author timo gruen - 2021-01-07
 */
class PaginatedIterator<Resource>(
    page: Paginated<Resource>,
    val fetchNext: (Paginated<Resource>) -> Paginated<Resource>
)
    : Iterator<Resource>
{
    private var currentPage = page
    private var currentIter = page.results.iterator()

    override fun hasNext(): Boolean {
        if (!currentIter.hasNext()) {
            currentPage = fetchNext(currentPage)
            currentIter = currentPage.results.iterator()
            return currentIter.hasNext()
        }
        return true
    }

    override fun next(): Resource {
        return currentIter.next()
    }
}
