package io.datalbry.confluence.cloud.client.feign.extensions

import feign.Feign
import feign.auth.BasicAuthRequestInterceptor
import feign.jackson.JacksonDecoder
import feign.jackson.JacksonEncoder
import feign.slf4j.Slf4jLogger
import io.datalbry.confluence.cloud.client.feign.config.ConfluenceCloudClientConfig

/**
 * Default instance of the Feign Builder, preconfigured with Jackson decoder and encoder
 */
val defaultBuilder: Feign.Builder = Feign
    .Builder()
    .decoder(JacksonDecoder(jackson()))
    .encoder(JacksonEncoder(jackson()))

/**
 * Extension function for the Feign.Builder, enabling building of interfaces just by their type
 *
 * @param config of the Confluence instance
 * @param FeignDefinition to build
 *
 * @return Created instance of type FeignDefinition
 */
inline fun <reified FeignDefinition> Feign.Builder.build(config: ConfluenceCloudClientConfig): FeignDefinition {
    this.requestInterceptor(BasicAuthRequestInterceptor(config.username, config.password))
    this.logger(Slf4jLogger(FeignDefinition::class.java))
    return this.target(FeignDefinition::class.java, config.uri.toString())
}
