package io.datalbry.confluence.cloud.client.feign.content

import feign.Param
import feign.QueryMap
import feign.RequestLine
import io.datalbry.confluence.cloud.client.model.ContentId
import io.datalbry.confluence.cloud.client.model.Paginated
import io.datalbry.confluence.cloud.client.model.Restrictions
import io.datalbry.confluence.cloud.client.model.content.Content

interface FeignContentResource {
    @RequestLine("GET /wiki/rest/api/content/{id}")
    fun getContent(
        @Param("id") contentId: String,
        @QueryMap queryMap: Map<String, String> = query()
    ): Content

    @RequestLine("GET /wiki/rest/api/content/{id}/child/attachment?limit={limit}&start={start}")
    fun getContentAttachments(
        @Param("limit") limit: Int,
        @Param("start") start: Int,
        @Param("id") contentId: String,
    ): Paginated<ContentId>

    @RequestLine("GET /wiki/rest/api/content/{id}/child/comment?limit={limit}&start={start}")
    fun getContentComments(
        @Param("limit") limit: Int,
        @Param("start") start: Int,
        @Param("id") contentId: String,
    ): Paginated<ContentId>

    @RequestLine("GET /wiki/rest/api/content$ID_QUERY")
    fun getPageIds(
        @Param("limit") limit: Int,
        @Param("start") start: Int,
        @Param("spaceKey") spaceKey: String,
    ): Paginated<ContentId>

    @RequestLine("GET /wiki/rest/api/content$ID_QUERY&type=blogpost")
    fun getBlogPostIds(
        @Param("limit") limit: Int,
        @Param("start") start: Int,
        @Param("spaceKey") spaceKey: String
    ): Paginated<ContentId>

    @RequestLine("GET /wiki/rest/api/content/{id}/restriction/byOperation/read$RESTRICTION_QUERY")
    fun getReadRestrictions(
        @Param("limit") limit: Int,
        @Param("start") start: Int,
        @Param("id") contentId: String,
    ): Restrictions

    private fun query() = mapOf("expand" to PAGE_QUERY)

    companion object {
        const val PAGE_QUERY: String = "container,ancestors,history,version,body.view,metadata.labels"
        const val ID_QUERY: String = "?limit={limit}&start={start}&spaceKey={spaceKey}"
        const val RESTRICTION_QUERY: String = "?limit={limit}&start={start}"
    }
}
