package io.datalbry.confluence.cloud.client.feign.content

import io.datalbry.confluence.cloud.client.model.ACL
import io.datalbry.confluence.cloud.client.ContentClient
import io.datalbry.confluence.cloud.client.model.ContentId
import io.datalbry.confluence.cloud.client.feign.iterator.PaginatedIterator
import io.datalbry.confluence.cloud.client.model.content.Content
import io.datalbry.confluence.cloud.client.model.space.SpaceKey

/**
 * TODO()
 */
class FeignContentClient(private val feign: FeignContentResource) : ContentClient {

    override fun getContent(id: ContentId): Content {
        return feign.getContent(id.id)
    }

    override fun getContentAttachments(id: ContentId, pageSize: Int): Iterator<ContentId> {
        val page = feign.getContentAttachments(start = 0, limit = pageSize, contentId = id.id)
        return PaginatedIterator(page) { feign.getContentAttachments(pageSize, it.start + it.size, id.id) }
    }

    override fun getContentComments(id: ContentId, pageSize: Int): Iterator<ContentId> {
        val page = feign.getContentComments(start = 0, limit = pageSize, contentId = id.id)
        return PaginatedIterator(page) { feign.getContentComments(pageSize, it.start + it.size, id.id) }
    }

    override fun getPageIds(spaceKey: SpaceKey, pageSize: Int): Iterator<ContentId> {
        val page = feign.getPageIds(start = 0, limit = pageSize, spaceKey = spaceKey.key)
        return PaginatedIterator(page) { feign.getPageIds(pageSize, it.start + it.size, spaceKey.key) }
    }

    override fun getBlogPostIds(spaceKey: SpaceKey, pageSize: Int): Iterator<ContentId> {
        val page = feign.getBlogPostIds(start = 0, limit = pageSize, spaceKey = spaceKey.key)
        return PaginatedIterator(page) { feign.getBlogPostIds(pageSize, it.start + it.size, spaceKey.key) }
    }

    override fun getRestrictions(id: ContentId, pageSize: Int): ACL {
        val acl = feign.getReadRestrictions(start = 0, limit = pageSize, contentId = id.id)
        val userIter = PaginatedIterator(acl.restrictions.user) {
            feign.getReadRestrictions(pageSize, it.start + it.limit, id.id).restrictions.user
        }
        val groupIter = PaginatedIterator(acl.restrictions.group) {
            feign.getReadRestrictions(pageSize, it.start + it.limit, id.id).restrictions.group
        }
        return ACL(userIter, groupIter)
    }
}
