package io.datalbry.confluence.cloud.client.feign

import io.datalbry.confluence.cloud.client.ConfluenceCloudClient
import io.datalbry.confluence.cloud.client.feign.config.ConfluenceCloudClientConfig
import io.datalbry.confluence.cloud.client.feign.extensions.defaultBuilder
import io.datalbry.confluence.cloud.client.feign.extensions.build
import io.datalbry.confluence.cloud.client.feign.content.FeignContentClient
import io.datalbry.confluence.cloud.client.feign.space.FeignSpaceClient

/**
 * Factory for a [ConfluenceCloudClient]
 */
class ConfluenceCloudClientFactory {
    /**
     * Creating all clients and creates a new instance of the [ConfluenceCloudClient]
     *
     * @param config of the Confluence instance to run requests against
     *
     * @return newly created instance of [ConfluenceCloudClient]]
     */
    fun create(config: ConfluenceCloudClientConfig): ConfluenceCloudClient {
        val builder = defaultBuilder
        val spaceClient = FeignSpaceClient(builder.build(config))
        val pageClient = FeignContentClient(builder.build(config))
        return ConfluenceCloudClient(spaceClient, pageClient)
    }
}
