/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.websocket;

import io.datafx.io.DataReader;
import io.datafx.io.converter.InputStreamConverter;
import io.datafx.websocket.DataFXEndpoint;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ContainerProvider;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class WebSocketReader<T>
implements DataReader<T> {
    private String address;
    private boolean connected = false;
    private List<String> availableData = Collections.synchronizedList(new LinkedList());
    private final Object availableLock = new Object();
    private boolean closed = false;
    private Session session;
    private InputStreamConverter converter;

    public WebSocketReader(String address) {
        this.address = address;
        DataFXEndpoint.parent = this;
    }

    public void setConverter(InputStreamConverter converter) {
        this.converter = converter;
    }

    private void connectEndpoint() {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            this.session = container.connectToServer(DataFXEndpoint.class, null, new URI(this.address));
            this.connected = true;
        }
        catch (Exception ex) {
            Logger.getLogger(WebSocketReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAvailableData(String data) {
        System.out.println("WebSocketReader has new data");
        Object object = this.availableLock;
        synchronized (object) {
            this.availableData.add(data);
            this.availableLock.notifyAll();
        }
        System.out.println("WebSocketReader was notified new data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws IOException {
        System.out.println("WebSocketReader in get...");
        Object object = this.availableLock;
        synchronized (object) {
            if (!this.connected) {
                System.out.println("WebSocketReader needs to connect first...");
                this.connectEndpoint();
                System.out.println("WebSocketReader connected...");
            }
            if (this.availableData.isEmpty()) {
                System.out.println("WebSocketReader waits for available data...");
                try {
                    this.availableLock.wait();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.getLogger(WebSocketReader.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        System.out.println("WebSocketReader GOT available data...");
        String msg = this.availableData.remove(0);
        if (this.converter != null) {
            this.converter.initialize((Object)new ByteArrayInputStream(msg.getBytes()));
            return (T)this.converter.get();
        }
        return (T)msg;
    }

    public boolean next() {
        return !this.closed;
    }

    public void sendMessage(String msg) throws IOException {
        this.session.getBasicRemote().sendText(msg);
    }

    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("WebSockets don't support iterators.");
    }
}

