/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.validation.ui;

import io.datafx.controller.validation.event.ValidationFinishedEvent;
import io.datafx.controller.validation.event.ValidationFinishedHandler;
import io.datafx.controller.validation.ui.ViolationBinding;
import io.datafx.controller.validation.ui.ViolationMapper;
import io.datafx.core.DataFXUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javax.validation.ConstraintViolation;
import javax.validation.Path;

public class ViolationBindingManager<U>
implements ValidationFinishedHandler<U> {
    ObservableList<ViolationMapper> bindings = FXCollections.observableArrayList();

    public ViolationBindingManager(U controller) {
        Field[] fields;
        for (Field field : fields = controller.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ViolationBinding.class)) continue;
            ViolationBinding violationBinding = field.getAnnotation(ViolationBinding.class);
            Object value = DataFXUtils.getPrivileged((Field)field, controller);
            ViolationMapper mapper = this.createMapper(value, violationBinding.path(), violationBinding.useSubPaths());
            if (mapper == null) continue;
            this.bindings.add((Object)mapper);
        }
    }

    private ViolationMapper createMapper(Object value, String path, boolean useSubPaths) {
        if (value != null) {
            if (value instanceof Node) {
                return new ViolationMapper(path, useSubPaths);
            }
            throw new RuntimeException("Unknown Type");
        }
        throw new NullPointerException("value == null");
    }

    public void update(Set<ConstraintViolation<U>> violations) {
        for (ViolationMapper binding : this.bindings) {
            ArrayList matchingViolations = new ArrayList();
            for (ConstraintViolation<U> violation : violations) {
                if (!this.isMatching(violation.getPropertyPath(), binding.path(), binding.getUseSubPaths())) continue;
                matchingViolations.add(violation);
            }
            binding.setViolations(matchingViolations);
        }
    }

    private boolean isMatching(Path path, String pathAsString, boolean useSubpath) {
        return true;
    }

    public void handle(ValidationFinishedEvent<U> event) {
        this.update(event.getViolations());
    }
}

