/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.validation;

import io.datafx.controller.context.ViewContext;
import io.datafx.controller.validation.event.ValidationFinishedEvent;
import io.datafx.controller.validation.event.ValidationFinishedHandler;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidatorFX<U> {
    private Validator validator;
    private U controller;
    private ObjectProperty<ValidationFinishedHandler> onValidationFinished;

    public ValidatorFX(ViewContext<U> context) {
        this(context.getController());
    }

    public ValidatorFX(U controller) {
        this.controller = controller;
        Configuration validationConf = Validation.byDefaultProvider().configure();
        this.validator = validationConf.buildValidatorFactory().getValidator();
    }

    public Set<ConstraintViolation<U>> validateAllProperties(Class<?> ... groups) {
        Set violations = this.validator.validate(this.controller, (Class[])groups);
        if (this.onValidationFinished != null && this.onValidationFinished.get() != null) {
            ((ValidationFinishedHandler)this.onValidationFinished.get()).handle(new ValidationFinishedEvent(violations));
        }
        return violations;
    }

    public ObjectProperty<ValidationFinishedHandler> validationFinishedHandlerProperty() {
        if (this.onValidationFinished == null) {
            this.onValidationFinished = new SimpleObjectProperty();
        }
        return this.onValidationFinished;
    }

    public void setOnValidationFinished(ValidationFinishedHandler handler) {
        this.validationFinishedHandlerProperty().set((Object)handler);
    }
}

