/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.validation.flow;

import io.datafx.controller.context.ViewContext;
import io.datafx.controller.flow.event.BeforeFlowActionEvent;
import io.datafx.controller.flow.event.VetoableBeforeFlowActionHandler;
import io.datafx.controller.validation.ValidatorFX;
import io.datafx.controller.validation.flow.ViolationVeto;
import java.util.Set;
import javax.validation.ConstraintViolation;

public class DefaultValidationListener<U>
implements VetoableBeforeFlowActionHandler {
    private ValidatorFX<U> validator;
    private Class<?>[] groups;

    public DefaultValidationListener(ViewContext<U> context, Class<?> ... groups) {
        this(new ValidatorFX<ViewContext<U>>(context), groups);
    }

    public DefaultValidationListener(ValidatorFX<U> validator, Class<?> ... groups) {
        this.validator = validator;
        this.groups = groups;
    }

    public ValidatorFX<U> getValidator() {
        return this.validator;
    }

    public void handle(BeforeFlowActionEvent event) throws ViolationVeto {
        Set<ConstraintViolation<U>> violations;
        if (!this.validateOnAction(event) || (violations = this.validator.validateAllProperties(this.groups)) == null || violations.isEmpty() || this.vetoOnViolations(event, violations)) {
            // empty if block
        }
    }

    protected boolean validateOnAction(BeforeFlowActionEvent event) {
        return true;
    }

    protected boolean vetoOnViolations(BeforeFlowActionEvent event, Set<ConstraintViolation<U>> violations) {
        return true;
    }
}

