/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.form;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class SimpleForm
extends VBox {
    private AnchorPane titlePane;
    private Label titleLabel;
    private GridPane mainPane;
    private FlowPane actionPane;
    private int rowCount = 0;

    public SimpleForm() {
        this.setSpacing(12.0);
        this.titlePane = new AnchorPane();
        this.titlePane.getStyleClass().add((Object)"datafx-form-title");
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"datafx-form-title-label");
        AnchorPane.setLeftAnchor((Node)this.titleLabel, (Double)12.0);
        AnchorPane.setTopAnchor((Node)this.titleLabel, (Double)6.0);
        AnchorPane.setBottomAnchor((Node)this.titleLabel, (Double)6.0);
        this.titlePane.getChildren().add((Object)this.titleLabel);
        this.titlePane.setVisible(false);
        this.getChildren().add((Object)this.titlePane);
        this.mainPane = new GridPane();
        this.mainPane.setAlignment(Pos.CENTER_RIGHT);
        this.mainPane.setHgap(12.0);
        this.mainPane.setVgap(6.0);
        VBox.setMargin((Node)this.mainPane, (Insets)new Insets(0.0, 16.0, 0.0, 16.0));
        this.getChildren().add((Object)this.mainPane);
        this.actionPane = new FlowPane();
        this.actionPane.setAlignment(Pos.CENTER_RIGHT);
        this.actionPane.setHgap(6.0);
        VBox.setMargin((Node)this.actionPane, (Insets)new Insets(0.0, 16.0, 12.0, 16.0));
        this.getChildren().add((Object)this.actionPane);
    }

    public Button addAction(String name, EventHandler<ActionEvent> eventHandler) {
        Button actionButton = new Button(name);
        actionButton.setOnAction(eventHandler);
        actionButton.getStyleClass().add((Object)"datafx-form-button");
        this.addToActionPane((Node)actionButton);
        return actionButton;
    }

    public void addToActionPane(Node node) {
        this.actionPane.getChildren().add((Object)node);
    }

    public void add(String dataName, Node dataNode) {
        this.add((Node)new Label(dataName), dataNode);
    }

    public void add(Node labelNode, Node dataNode) {
        GridPane.setConstraints((Node)labelNode, (int)0, (int)this.rowCount);
        GridPane.setConstraints((Node)dataNode, (int)1, (int)this.rowCount);
        GridPane.setHgrow((Node)labelNode, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)dataNode, (Priority)Priority.ALWAYS);
        GridPane.setHalignment((Node)labelNode, (HPos)HPos.RIGHT);
        GridPane.setHalignment((Node)dataNode, (HPos)HPos.LEFT);
        this.mainPane.getChildren().addAll((Object[])new Node[]{labelNode, dataNode});
        ++this.rowCount;
    }

    public StringProperty formTitleProperty() {
        return this.titleLabel.textProperty();
    }

    public void setFormTitle(String formTitle) {
        this.formTitleProperty().set((Object)formTitle);
    }

    public BooleanProperty titleVisibleProperty() {
        return this.titlePane.visibleProperty();
    }
}

