/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import io.datafx.core.concurrent.DataFxService;
import java.io.IOException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.AnchorPane;

public class ServiceListCell<T>
extends ListCell<Service<T>> {
    @FXML
    private Label taskTitleLabel;
    @FXML
    private Label taskMessageLabel;
    @FXML
    private Button killTaskButton;
    @FXML
    private ProgressBar taskProgress;
    @FXML
    private AnchorPane anchorPane;

    public ServiceListCell() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ServiceListCell.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.setGraphic((Node)this.anchorPane);
        this.anchorPane.setVisible(false);
        this.killTaskButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                Service service = (Service)ServiceListCell.this.getItem();
                if (service != null) {
                    service.cancel();
                }
            }
        });
        this.itemProperty().addListener(new ChangeListener<Service<?>>(){

            public void changed(ObservableValue<? extends Service<?>> observableValue, Service<?> oldValue, Service<?> newValue) {
                try {
                    if (oldValue != null) {
                        ServiceListCell.this.taskTitleLabel.textProperty().unbind();
                        ServiceListCell.this.taskMessageLabel.textProperty().unbind();
                        ServiceListCell.this.taskProgress.progressProperty().unbind();
                        ServiceListCell.this.killTaskButton.visibleProperty().unbind();
                    }
                    if (newValue != null) {
                        ServiceListCell.this.taskTitleLabel.textProperty().bind((ObservableValue)newValue.titleProperty());
                        ServiceListCell.this.taskMessageLabel.textProperty().bind((ObservableValue)newValue.messageProperty());
                        ServiceListCell.this.taskProgress.progressProperty().bind((ObservableValue)newValue.progressProperty());
                        if (newValue instanceof DataFxService) {
                            ServiceListCell.this.killTaskButton.visibleProperty().bind((ObservableValue)((DataFxService)newValue).cancelableProperty());
                        } else {
                            ServiceListCell.this.killTaskButton.visibleProperty().set(true);
                        }
                        ServiceListCell.this.anchorPane.setVisible(true);
                    } else {
                        ServiceListCell.this.anchorPane.setVisible(false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

