/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import io.datafx.control.TableViewFactory;
import io.datafx.control.cell.LabelTableCell;
import io.datafx.control.cell.MoneyCell;
import java.net.URL;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class MoneyTableCell<S, T extends Number>
extends LabelTableCell<S, T> {
    private final Locale locale;

    public MoneyTableCell() {
        this(Locale.getDefault());
    }

    public MoneyTableCell(Locale locale) {
        this.getStyleClass().add((Object)"money-cell");
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    protected String getUserAgentStylesheet() {
        URL resource = TableViewFactory.class.getResource("cells.css");
        if (resource != null) {
            return resource.toString();
        }
        return null;
    }

    @Override
    public void getCssState(List<String> s) {
        MoneyCell.getCssState(this, s);
    }

    @Override
    public String toString(T item) {
        String str = item == null ? "" : NumberFormat.getCurrencyInstance(this.locale).format(item);
        this.stateChanged("negative", "positive");
        return str;
    }
}

