/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import com.sun.javafx.scene.control.skin.TableRowSkin;
import io.datafx.control.cell.ExpandOnMouseEventCell;
import io.datafx.control.cell.ExpandingTableCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class ExpandOnMouseEventTableRow<S>
extends TableRow<S> {
    public static final double DEFAULT_PREF_HEIGHT = 24.0;
    public static final double DEFAULT_EXPAND_HEIGHT = 72.0;
    private static final EventType<?> CELL_RESIZE_EVENT = new EventType(Event.ANY, "CELL_RESIZE");
    private int maxExpandedCells = 1;
    private final double expandedHeight;

    public static <T> EventType<CellResizeEvent<T>> cellResizeEvent() {
        return CELL_RESIZE_EVENT;
    }

    public ExpandOnMouseEventTableRow() {
        this(1);
    }

    public ExpandOnMouseEventTableRow(int maxExpandedCells) {
        this(maxExpandedCells, 72.0, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public ExpandOnMouseEventTableRow(int maxExpandedCells, double expandHeight) {
        this(maxExpandedCells, expandHeight, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public ExpandOnMouseEventTableRow(int maxExpandedCells, double expandHeight, EventType<MouseEvent> mouseEventType) {
        this.maxExpandedCells = maxExpandedCells >= 0 ? maxExpandedCells : 1;
        this.expandedHeight = expandHeight < 0.0 ? 72.0 : expandHeight;
        this.setEditable(false);
        this.prefHeightProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                ExpandOnMouseEventTableRow.this.requestLayout();
            }
        });
        this.addEventFilter(mouseEventType == null ? MouseEvent.MOUSE_CLICKED : mouseEventType, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (ExpandOnMouseEventTableRow.this.isEmpty()) {
                    return;
                }
                ExpandOnMouseEventTableRow.flip(ExpandOnMouseEventTableRow.this, ExpandOnMouseEventTableRow.this.getMaxExpandedCells());
            }
        });
    }

    public void updateIndex(int i) {
        super.updateIndex(i);
        if (this.isExpanded()) {
            this.setPrefHeight(72.0);
        } else {
            this.setPrefHeight(24.0);
        }
    }

    public void setOnCellResize(EventHandler<CellResizeEvent<S>> evt) {
        if (evt == null) {
            return;
        }
        this.addEventHandler(ExpandOnMouseEventTableRow.cellResizeEvent(), evt);
    }

    private static void flip(ExpandOnMouseEventTableRow<?> cell, int maxExpandedCells) {
        List<Integer> expandedIndices;
        Queue<Cell> expandedCells = ExpandOnMouseEventCell.expandedCellsMap.get(cell.getTableView());
        if (expandedCells == null) {
            expandedCells = new LinkedBlockingQueue<Cell>();
            ExpandOnMouseEventCell.expandedCellsMap.put((Control)cell.getTableView(), expandedCells);
        }
        if ((expandedIndices = ExpandOnMouseEventCell.expandedIndicesMap.get(cell.getTableView())) == null) {
            expandedIndices = new ArrayList<Integer>();
            ExpandOnMouseEventCell.expandedIndicesMap.put((Control)cell.getTableView(), expandedIndices);
        }
        boolean cellIsExpanded = expandedCells.contains(cell);
        if (maxExpandedCells <= expandedCells.size() && !cellIsExpanded) {
            ExpandOnMouseEventTableRow collapsed = (ExpandOnMouseEventTableRow)expandedCells.remove();
            ExpandOnMouseEventTableRow.animate(collapsed, false);
            expandedIndices.remove((Object)collapsed.getIndex());
        }
        if (cellIsExpanded) {
            expandedCells.remove(cell);
            expandedIndices.remove((Object)cell.getIndex());
        } else {
            expandedCells.add((Cell)cell);
            expandedIndices.add(cell.getIndex());
        }
        ExpandOnMouseEventTableRow.animate(cell, !cellIsExpanded);
    }

    public boolean isExpanded() {
        return ExpandOnMouseEventTableRow.isExpanded(this);
    }

    public static boolean isExpanded(ExpandOnMouseEventTableRow<?> cell) {
        if (ExpandOnMouseEventCell.expandedIndicesMap.containsKey(cell.getTableView())) {
            boolean isExpanded = ExpandOnMouseEventCell.expandedIndicesMap.get(cell.getTableView()).contains(cell.getIndex());
            return isExpanded;
        }
        return false;
    }

    public int getMaxExpandedCells() {
        return this.maxExpandedCells;
    }

    public void setMaxExpandedCells(int maxExpandedCells) {
        this.maxExpandedCells = maxExpandedCells;
    }

    protected double computePrefHeight(double width) {
        return this.isExpanded() ? this.getPrefHeight() : super.computePrefHeight(width);
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    private static <S> void animate(final ExpandOnMouseEventTableRow<S> cell, final boolean toExpanded) {
        double startHeight = cell.getHeight();
        double endHeight = toExpanded ? cell.expandedHeight : 24.0;
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        timeline.setAutoReverse(false);
        EventHandler<ActionEvent> fireEvent = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (!toExpanded && !ExpandOnMouseEventTableRow.isExpanded(cell)) {
                    ExpandOnMouseEventTableRow.fireEvents(cell, toExpanded);
                }
            }
        };
        KeyFrame firstFrame = new KeyFrame(Duration.ZERO, (EventHandler)fireEvent, new KeyValue[]{new KeyValue((WritableValue)cell.prefHeightProperty(), (Object)startHeight, Interpolator.EASE_BOTH)});
        EventHandler<ActionEvent> fireEvent2 = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (toExpanded && ExpandOnMouseEventTableRow.isExpanded(cell)) {
                    ExpandOnMouseEventTableRow.fireEvents(cell, toExpanded);
                }
            }
        };
        KeyFrame secondFrame = new KeyFrame(Duration.millis((double)350.0), (EventHandler)fireEvent2, new KeyValue[]{new KeyValue((WritableValue)cell.prefHeightProperty(), (Object)endHeight, Interpolator.EASE_BOTH)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{firstFrame, secondFrame});
        timeline.playFromStart();
    }

    private static <S> void fireEvents(ExpandOnMouseEventTableRow<S> tableRow, boolean toExpanded) {
        CellResizeEvent<S> event = new CellResizeEvent<S>(ExpandOnMouseEventTableRow.cellResizeEvent(), tableRow, toExpanded);
        tableRow.fireEvent(event);
        Map<TableColumn, TableCell> cells = event.getCells();
        for (Map.Entry<TableColumn, TableCell> e : cells.entrySet()) {
            if (!(e.getValue() instanceof ExpandingTableCell)) continue;
            ((ExpandingTableCell)e.getValue()).updateExpanded(toExpanded);
        }
    }

    public static class CellResizeEvent<S>
    extends Event {
        private final ExpandOnMouseEventTableRow<S> tableRow;
        private final boolean expanded;
        private Map<TableColumn, TableCell> cells;

        public CellResizeEvent(EventType<? extends Event> eventType, ExpandOnMouseEventTableRow<S> tableRow, boolean isExpanded) {
            super(eventType);
            this.tableRow = tableRow;
            this.expanded = isExpanded;
        }

        public ExpandOnMouseEventTableRow<S> getTableRow() {
            return this.tableRow;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public Map<TableColumn, TableCell> getCells() {
            if (this.cells != null) {
                return this.cells;
            }
            if (this.tableRow.getSkin() instanceof TableRowSkin) {
                TableRowSkin trs = (TableRowSkin)this.tableRow.getSkin();
                ObservableList children = trs.getChildren();
                if (children == null || children.isEmpty()) {
                    return Collections.emptyMap();
                }
                this.cells = new WeakHashMap<TableColumn, TableCell>();
                for (int i = 0; i < children.size(); ++i) {
                    TableCell tableCell;
                    Node n = (Node)children.get(i);
                    if (!(n instanceof TableCell) || (tableCell = (TableCell)n).getTableColumn() == null) continue;
                    this.cells.put(tableCell.getTableColumn(), tableCell);
                }
                return this.cells;
            }
            return Collections.emptyMap();
        }
    }
}

