/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import io.datafx.control.cell.ExpandOnMouseEventCell;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;

public class ExpandOnMouseEventListCell<T>
extends ListCell<T> {
    public static final double DEFAULT_PREF_HEIGHT = 24.0;
    public static final double DEFAULT_EXPAND_HEIGHT = 72.0;
    private int maxExpandedCells = 1;
    private final double expandedHeight;
    private Callback<CellResizeFeatures<T>, CellUpdate> onCellResizeStarting;

    public ExpandOnMouseEventListCell() {
        this(1);
    }

    public ExpandOnMouseEventListCell(int maxExpandedCells) {
        this(maxExpandedCells, 72.0, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public ExpandOnMouseEventListCell(int maxExpandedCells, double expandHeight) {
        this(maxExpandedCells, expandHeight, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public ExpandOnMouseEventListCell(int maxExpandedCells, double expandHeight, EventType<MouseEvent> mouseEventType) {
        this.maxExpandedCells = maxExpandedCells >= 0 ? maxExpandedCells : 1;
        this.expandedHeight = expandHeight < 0.0 ? 72.0 : expandHeight;
        this.prefHeightProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                ExpandOnMouseEventListCell.this.requestLayout();
            }
        });
        this.addEventFilter(mouseEventType == null ? MouseEvent.MOUSE_CLICKED : mouseEventType, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (ExpandOnMouseEventListCell.this.isEmpty()) {
                    return;
                }
                ExpandOnMouseEventListCell.flip(ExpandOnMouseEventListCell.this, ExpandOnMouseEventListCell.this.getMaxExpandedCells());
            }
        });
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.setText(item == null ? "" : item.toString());
    }

    public void updateIndex(int i) {
        super.updateIndex(i);
        if (this.isExpanded()) {
            this.setPrefHeight(this.expandedHeight);
        } else {
            this.setPrefHeight(24.0);
        }
    }

    public void setOnCellResizeStarting(Callback<CellResizeFeatures<T>, CellUpdate> onCellResizeStarting) {
        this.onCellResizeStarting = onCellResizeStarting;
    }

    private static synchronized void flip(ExpandOnMouseEventListCell<?> cell, int maxExpandedCells) {
        List<Integer> expandedIndices;
        Queue<Cell> expandedCells = ExpandOnMouseEventCell.expandedCellsMap.get(cell.getListView());
        if (expandedCells == null) {
            expandedCells = new LinkedBlockingQueue<Cell>();
            ExpandOnMouseEventCell.expandedCellsMap.put((Control)cell.getListView(), expandedCells);
        }
        if ((expandedIndices = ExpandOnMouseEventCell.expandedIndicesMap.get(cell.getListView())) == null) {
            expandedIndices = new ArrayList<Integer>();
            ExpandOnMouseEventCell.expandedIndicesMap.put((Control)cell.getListView(), expandedIndices);
        }
        boolean cellIsExpanded = expandedCells.contains(cell);
        if (maxExpandedCells <= expandedCells.size() && !cellIsExpanded) {
            ExpandOnMouseEventListCell collapsed = (ExpandOnMouseEventListCell)expandedCells.remove();
            ExpandOnMouseEventListCell.animate(collapsed, false);
            expandedIndices.remove((Object)collapsed.getIndex());
        }
        if (cellIsExpanded) {
            expandedCells.remove(cell);
            expandedIndices.remove((Object)cell.getIndex());
        } else {
            expandedCells.add((Cell)cell);
            expandedIndices.add(cell.getIndex());
        }
        ExpandOnMouseEventListCell.animate(cell, !cellIsExpanded);
    }

    public boolean isExpanded() {
        if (ExpandOnMouseEventCell.expandedIndicesMap.containsKey(this.getListView())) {
            return ExpandOnMouseEventCell.expandedIndicesMap.get(this.getListView()).contains(this.getIndex());
        }
        return false;
    }

    public int getMaxExpandedCells() {
        return this.maxExpandedCells;
    }

    public void setMaxExpandedCells(int maxExpandedCells) {
        this.maxExpandedCells = maxExpandedCells;
    }

    protected double computePrefHeight(double width) {
        return this.isExpanded() ? this.getPrefHeight() : super.computePrefHeight(width);
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    private static <T> void animate(final ExpandOnMouseEventListCell<T> cell, boolean toExpanded) {
        double startHeight = cell.getHeight();
        double endHeight = toExpanded ? cell.expandedHeight : 24.0;
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        timeline.setAutoReverse(false);
        CellResizeFeatures<T> crf = new CellResizeFeatures<T>(cell, toExpanded);
        CellUpdate cellUpdate = cell.onCellResizeStarting == null ? null : (CellUpdate)cell.onCellResizeStarting.call(crf);
        final String text = cellUpdate == null ? cell.getText() : cellUpdate.text;
        final Node graphic = cellUpdate == null ? cell.getGraphic() : cellUpdate.graphic;
        double endOpacity = toExpanded ? 1.0 : 0.0;
        KeyFrame firstFrame = graphic == null ? new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)cell.prefHeightProperty(), (Object)startHeight, Interpolator.EASE_BOTH)}) : new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)cell.prefHeightProperty(), (Object)startHeight, Interpolator.EASE_BOTH), new KeyValue((WritableValue)graphic.opacityProperty(), (Object)1.0, Interpolator.EASE_BOTH)});
        EventHandler<ActionEvent> replaceGraphicEvent = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                cell.setText(text);
                cell.setGraphic(graphic);
            }
        };
        KeyFrame secondFrame = graphic == null ? new KeyFrame(Duration.millis((double)175.0), (EventHandler)replaceGraphicEvent, new KeyValue[0]) : new KeyFrame(Duration.millis((double)175.0), (EventHandler)replaceGraphicEvent, new KeyValue[]{new KeyValue((WritableValue)graphic.opacityProperty(), (Object)0.0, Interpolator.EASE_BOTH)});
        EventHandler<ActionEvent> fireEvent2 = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                cell.setGraphic(graphic);
            }
        };
        KeyFrame thirdFrame = graphic == null ? new KeyFrame(Duration.millis((double)350.0), (EventHandler)fireEvent2, new KeyValue[]{new KeyValue((WritableValue)cell.prefHeightProperty(), (Object)endHeight, Interpolator.EASE_BOTH)}) : new KeyFrame(Duration.millis((double)350.0), (EventHandler)fireEvent2, new KeyValue[]{new KeyValue((WritableValue)cell.prefHeightProperty(), (Object)endHeight, Interpolator.EASE_BOTH), new KeyValue((WritableValue)graphic.opacityProperty(), (Object)endOpacity, Interpolator.EASE_BOTH)});
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{firstFrame, secondFrame, thirdFrame});
        timeline.playFromStart();
    }

    public static class CellUpdate {
        private Node graphic;
        private String text;

        public CellUpdate(String text, Node graphic) {
            this.text = text;
            this.graphic = graphic;
        }
    }

    public static class CellResizeFeatures<T> {
        public final Cell<T> cell;
        public final boolean isExpanded;

        public CellResizeFeatures(Cell<T> cell, boolean isExpanded) {
            this.cell = cell;
            this.isExpanded = isExpanded;
        }
    }
}

