/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import javafx.scene.Node;
import javafx.scene.control.ListCell;

public class DefaultListCell<T>
extends ListCell<T> {
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (item instanceof Node) {
            this.setText(null);
            Node currentNode = this.getGraphic();
            Node newNode = (Node)item;
            if (currentNode == null || !currentNode.equals(newNode)) {
                this.setGraphic(newNode);
            }
        } else {
            this.setText(item == null ? "null" : item.toString());
            this.setGraphic(null);
        }
    }
}

