/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.ChoiceBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;

public class TableViewFactory<S> {
    private TableView<S> table;
    private ObservableList<TableColumn<S, ?>> columns;
    private boolean columnSelectPerformed = false;
    private ObservableList<TableColumn<S, ?>> finalColumns;

    private TableViewFactory() {
    }

    public static <S> TableView<S> create(Class<? extends S> dataType) {
        List<TableColumn<? extends S, ?>> columns = TableViewFactory.createColumns(dataType);
        TableView table = new TableView();
        table.getColumns().setAll(columns);
        return table;
    }

    public static <S> TableViewFactory<S> create(List<? extends S> items) {
        return TableViewFactory.create(FXCollections.observableArrayList(items));
    }

    public static <S> TableViewFactory<S> create(Class<? extends S> dataType, List<S> items) {
        return TableViewFactory.create(dataType, FXCollections.observableArrayList(items));
    }

    public static <S> TableViewFactory<S> create(ObservableList<? extends S> items) {
        return TableViewFactory.create(null, FXCollections.observableArrayList(items));
    }

    public static <S> TableViewFactory<S> create(Class<? extends S> dataType, final ObservableList<S> items) {
        if (items == null) {
            throw new NullPointerException("items can not be null");
        }
        final TableView table = new TableView();
        table.setItems(items);
        table.setEditable(true);
        if (dataType == null && table.getItems().isEmpty()) {
            InvalidationListener listener = new InvalidationListener(){

                public void invalidated(Observable o) {
                    if (!table.getItems().isEmpty()) {
                        TableViewFactory.createColumns(table);
                        items.removeListener((InvalidationListener)this);
                    }
                }
            };
            table.getItems().addListener(listener);
        } else {
            TableViewFactory.createColumns(table);
        }
        return TableViewFactory.configure(table);
    }

    private static <S> void createColumns(TableView<S> table) {
        Class<?> actualDataType = table.getItems().get(0).getClass();
        if (actualDataType != null) {
            List<TableColumn<?, ?>> columns = TableViewFactory.createColumns(actualDataType);
            table.getColumns().setAll(columns);
        }
    }

    private static <S> List<TableColumn<S, ?>> createColumns(Class<? extends S> dataType) {
        ArrayList columns = new ArrayList();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(dataType);
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor pd = properties[i];
                if ("class".equals(pd.getName()) || pd.getReadMethod() == null) continue;
                Class<?> propertyDataType = pd.getPropertyType();
                String displayName = TableViewFactory.makePrettyDisplayName(pd.getDisplayName());
                TableColumn column = new TableColumn();
                column.setText(displayName);
                column.setCellValueFactory((Callback)new PropertyValueFactory(pd.getName()));
                columns.add(column);
                if (propertyDataType.isEnum()) {
                    Object[] enumConstants = propertyDataType.getEnumConstants();
                    column.setCellFactory(ChoiceBoxTableCell.forTableColumn((Object[])enumConstants));
                    continue;
                }
                if (propertyDataType == Boolean.TYPE) {
                    column.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)column));
                    continue;
                }
                if (propertyDataType != String.class) continue;
                column.setCellFactory(TextFieldTableCell.forTableColumn());
            }
        }
        catch (IntrospectionException ex) {
            ex.printStackTrace();
        }
        return columns;
    }

    private static String makePrettyDisplayName(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        ArrayList<Character> charList = new ArrayList<Character>(chars.length);
        for (i = 0; i < chars.length; ++i) {
            char c1;
            char c0 = chars[i];
            char c = c1 = i > 0 ? chars[i - 1] : (char)' ';
            if (i == 0) {
                charList.add(Character.valueOf(Character.toUpperCase(c0)));
                continue;
            }
            if (Character.isUpperCase(c0) && !Character.isUpperCase(c1)) {
                charList.add(Character.valueOf(' '));
            }
            charList.add(Character.valueOf(c0));
        }
        chars = new char[charList.size()];
        for (i = 0; i < charList.size(); ++i) {
            chars[i] = ((Character)charList.get(i)).charValue();
        }
        return new String(chars);
    }

    public static <S> TableViewFactory<S> configure(TableView<S> table) {
        return new TableViewFactory<S>(table);
    }

    public static <S> void print(TableView<S> table) {
        TableViewFactory.print(table.getColumns());
    }

    public static <S> void print(ObservableList<TableColumn<S, ?>> columns) {
        System.out.println("Columns:");
        for (int i = 0; i < columns.size(); ++i) {
            TableColumn tc = (TableColumn)columns.get(i);
            System.out.println("    Text: " + tc.getText());
        }
    }

    private TableViewFactory(TableView<S> table) {
        this.table = table;
        this.columns = table.getColumns();
        this.finalColumns = FXCollections.observableArrayList();
        if (this.columns == null) {
            throw new NullPointerException("Columns can not be null");
        }
    }

    public TableViewFactory<S> selectColumns(String ... names) {
        if (names == null || names.length == 0) {
            return this;
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            for (int j = 0; j < this.columns.size(); ++j) {
                TableColumn tc = (TableColumn)this.columns.get(j);
                if (name == null || !name.equals(tc.getText())) continue;
                this.finalColumns.add((Object)tc);
                this.columnSelectPerformed = true;
            }
        }
        return this;
    }

    public TableViewFactory<S> renameColumn(String oldName, String newName) {
        if (oldName == null || oldName.isEmpty() || newName == null || newName.isEmpty()) {
            return this;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            TableColumn tc = (TableColumn)this.columns.get(i);
            if (!oldName.equals(tc.getText())) continue;
            tc.setText(newName);
            break;
        }
        return this;
    }

    public ObservableList<TableColumn<S, ?>> buildColumns() {
        return this.finalColumns;
    }

    public TableView<S> buildTableView() {
        if (this.table == null) {
            this.table = new TableView();
        }
        if (this.columnSelectPerformed) {
            this.table.getColumns().setAll(this.finalColumns);
        } else if (!this.table.getColumns().equals(this.columns)) {
            this.table.getColumns().setAll(this.columns);
        }
        return this.table;
    }
}

