/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import io.datafx.control.cell.MoneyListCell;
import io.datafx.control.cell.MoneyTableCell;
import java.util.Locale;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class MoneyCellFactory {
    public static final String NEGATIVE_STATE = "negative";
    public static final String POSITIVE_STATE = "positive";

    private MoneyCellFactory() {
    }

    public static <T extends Number> Callback<ListView<T>, ListCell<T>> forListView() {
        return MoneyCellFactory.forListView(Locale.getDefault());
    }

    public static <T extends Number> Callback<ListView<T>, ListCell<T>> forListView(final Locale locale) {
        return new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> list) {
                return new MoneyListCell(locale);
            }
        };
    }

    public static <S, T extends Number> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn() {
        return MoneyCellFactory.forTableColumn(null, Locale.getDefault());
    }

    public static <S, T extends Number> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(TableColumn<S, T> column) {
        return MoneyCellFactory.forTableColumn(column, Locale.getDefault());
    }

    public static <S, T extends Number> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(TableColumn<S, T> column, final Locale locale) {
        return new Callback<TableColumn<S, T>, TableCell<S, T>>(){

            public TableCell<S, T> call(TableColumn<S, T> list) {
                return new MoneyTableCell(locale);
            }
        };
    }
}

