/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import io.datafx.control.cell.CSSTableCell;
import java.text.Format;
import javafx.scene.Node;
import javafx.scene.text.TextAlignment;

public class LabelTableCell<S, T>
extends CSSTableCell<S, T> {
    private Format format;

    public LabelTableCell() {
        this(TextAlignment.LEFT);
    }

    public LabelTableCell(Format format) {
        this(TextAlignment.LEFT, format);
    }

    public LabelTableCell(TextAlignment align) {
        this(align, null);
    }

    public LabelTableCell(TextAlignment align, Format format) {
        this.getStyleClass().add((Object)"label-cell");
        this.setTextAlignment(align);
        this.setFormat(format);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
        this.doUpdate();
    }

    public String toString(T item) {
        return item == null ? "" : item.toString();
    }

    public void updateItem(T item, boolean empty) {
        if (item == this.getItem()) {
            return;
        }
        super.updateItem(item, empty);
        this.doUpdate(item, empty);
    }

    private void doUpdate() {
        this.doUpdate(this.getItem(), this.isEmpty());
    }

    private void doUpdate(T item, boolean empty) {
        if (item == null || empty) {
            super.setText(null);
            super.setGraphic(null);
        } else if (this.format != null) {
            super.setText(this.format.format(item));
        } else if (item instanceof Node) {
            super.setText(null);
            super.setGraphic((Node)item);
        } else {
            super.setText(this.toString(item));
            super.setGraphic(null);
        }
    }
}

