/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import io.datafx.control.cell.LabelListCell;
import io.datafx.control.cell.LabelTableCell;
import io.datafx.control.cell.LabelTreeCell;
import java.text.Format;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class LabelCellFactory {
    private LabelCellFactory() {
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView() {
        return LabelCellFactory.forListView(TextAlignment.LEFT);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(TextAlignment align) {
        return LabelCellFactory.forListView(align, null);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(Format format) {
        return LabelCellFactory.forListView(TextAlignment.LEFT, format);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(final TextAlignment align, final Format format) {
        return new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> list) {
                return new LabelListCell(align, format);
            }
        };
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(final Callback<T, String> toString) {
        return new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> list) {
                return new LabelListCell<T>(){

                    @Override
                    public String toString(T item) {
                        return toString == null ? super.toString(item) : (String)toString.call(item);
                    }
                };
            }
        };
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView() {
        return LabelCellFactory.forTreeView(TextAlignment.LEFT);
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(TextAlignment align) {
        return LabelCellFactory.forTreeView(align, null);
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(Format format) {
        return LabelCellFactory.forTreeView(TextAlignment.LEFT, format);
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(final TextAlignment align, final Format format) {
        return new Callback<TreeView<T>, TreeCell<T>>(){

            public TreeCell<T> call(TreeView<T> list) {
                return new LabelTreeCell(align, format);
            }
        };
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(final Callback<T, String> toString) {
        return new Callback<TreeView<T>, TreeCell<T>>(){

            public TreeCell<T> call(TreeView<T> list) {
                return new LabelTreeCell<T>(){

                    @Override
                    public String toString(T item) {
                        return toString == null ? super.toString(item) : (String)toString.call(item);
                    }
                };
            }
        };
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn() {
        return LabelCellFactory.forTableColumn(TextAlignment.LEFT);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(TextAlignment align) {
        return LabelCellFactory.forTableColumn(align, null);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(Format format) {
        return LabelCellFactory.forTableColumn(TextAlignment.LEFT, format);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(final TextAlignment align, final Format format) {
        return new Callback<TableColumn<S, T>, TableCell<S, T>>(){

            public TableCell<S, T> call(TableColumn<S, T> list) {
                return new LabelTableCell(align, format);
            }
        };
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(final Callback<T, String> toString) {
        return new Callback<TableColumn<S, T>, TableCell<S, T>>(){

            public TableCell<S, T> call(TableColumn<S, T> list) {
                return new LabelTableCell<S, T>(){

                    @Override
                    public String toString(T item) {
                        return toString == null ? super.toString(item) : (String)toString.call(item);
                    }
                };
            }
        };
    }
}

