/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.control.cell;

import io.datafx.control.cell.ExpandOnMouseEventListCell;
import io.datafx.control.cell.ExpandOnMouseEventTableRow;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class ExpandOnMouseEventCellFactory {
    private ExpandOnMouseEventCellFactory() {
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView() {
        return ExpandOnMouseEventCellFactory.forListView(1);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(int maxExpandedCells) {
        return ExpandOnMouseEventCellFactory.forListView(maxExpandedCells, 72.0, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(int maxExpandedCells, double expandHeight) {
        return ExpandOnMouseEventCellFactory.forListView(maxExpandedCells, expandHeight, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(int maxExpandedCells, EventType<MouseEvent> mouseEventType) {
        return ExpandOnMouseEventCellFactory.forListView(maxExpandedCells, 72.0, mouseEventType);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(int maxExpandedCells, double expandHeight, EventType<MouseEvent> mouseEventType) {
        return ExpandOnMouseEventCellFactory.forListView(maxExpandedCells, expandHeight, mouseEventType, null);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(int maxExpandedCells, Callback<ExpandOnMouseEventListCell.CellResizeFeatures<T>, ExpandOnMouseEventListCell.CellUpdate> onCellResizeStarting) {
        return ExpandOnMouseEventCellFactory.forListView(maxExpandedCells, 72.0, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, onCellResizeStarting);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(int maxExpandedCells, double expandHeight, Callback<ExpandOnMouseEventListCell.CellResizeFeatures<T>, ExpandOnMouseEventListCell.CellUpdate> onCellResizeStarting) {
        return ExpandOnMouseEventCellFactory.forListView(maxExpandedCells, expandHeight, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, onCellResizeStarting);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(final int maxExpandedCells, final double expandHeight, final EventType<MouseEvent> mouseEventType, final Callback<ExpandOnMouseEventListCell.CellResizeFeatures<T>, ExpandOnMouseEventListCell.CellUpdate> onCellResizeStarting) {
        return new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> list) {
                ExpandOnMouseEventListCell cell = new ExpandOnMouseEventListCell(maxExpandedCells, expandHeight, (EventType<MouseEvent>)mouseEventType);
                cell.setOnCellResizeStarting(onCellResizeStarting);
                return cell;
            }
        };
    }

    public static <S> Callback<TableView<S>, TableRow<S>> forTableView() {
        return ExpandOnMouseEventCellFactory.forTableView(1);
    }

    public static <S> Callback<TableView<S>, TableRow<S>> forTableView(int maxExpandedCells) {
        return ExpandOnMouseEventCellFactory.forTableView(maxExpandedCells, 72.0, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public static <S> Callback<TableView<S>, TableRow<S>> forTableView(int maxExpandedCells, double expandHeight) {
        return ExpandOnMouseEventCellFactory.forTableView(maxExpandedCells, expandHeight, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public static <S> Callback<TableView<S>, TableRow<S>> forTableView(int maxExpandedCells, EventType<MouseEvent> mouseEventType) {
        return ExpandOnMouseEventCellFactory.forTableView(maxExpandedCells, 72.0, mouseEventType);
    }

    private static <S> Callback<TableView<S>, TableRow<S>> forTableView(int maxExpandedCells, EventHandler<ExpandOnMouseEventTableRow.CellResizeEvent<S>> onCellResize) {
        return ExpandOnMouseEventCellFactory.forTableView(maxExpandedCells, 72.0, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    private static <S> Callback<TableView<S>, TableRow<S>> forTableView(int maxExpandedCells, double expandHeight, EventHandler<ExpandOnMouseEventTableRow.CellResizeEvent<S>> onCellResize) {
        return ExpandOnMouseEventCellFactory.forTableView(maxExpandedCells, expandHeight, (EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED);
    }

    public static <S> Callback<TableView<S>, TableRow<S>> forTableView(final int maxExpandedCells, final double expandHeight, final EventType<MouseEvent> mouseEventType) {
        return new Callback<TableView<S>, TableRow<S>>(){

            public TableRow<S> call(TableView<S> list) {
                ExpandOnMouseEventTableRow cell = new ExpandOnMouseEventTableRow(maxExpandedCells, expandHeight, (EventType<MouseEvent>)mouseEventType);
                return cell;
            }
        };
    }
}

