/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.tutorial;

import io.datafx.controller.ViewNode;
import io.datafx.controller.flow.action.ActionMethod;
import io.datafx.controller.flow.action.ActionTrigger;
import io.datafx.tutorial.Model;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public abstract class AbstractController {
    @ViewNode
    @ActionTrigger(value="clear")
    private Button clearButton;
    @ViewNode
    @ActionTrigger(value="loadA")
    private Button loadAButton;
    @ViewNode
    @ActionTrigger(value="loadB")
    private Button loadBButton;
    @ViewNode
    @ActionTrigger(value="changeView")
    private Button changeView;
    @ViewNode
    private Label resultLabel;
    @Inject
    Model myModel;

    @PostConstruct
    public void init() {
        this.myModel.nameProperty().addListener(e -> this.resultLabel.setText(this.myModel.getName() + " is a " + this.myModel.getProfession()));
        this.myModel.professionProperty().addListener(e -> this.resultLabel.setText(this.myModel.getName() + " is a " + this.myModel.getProfession()));
        this.resultLabel.setText(this.myModel.getName() + " is a " + this.myModel.getProfession());
    }

    @ActionMethod(value="clear")
    private void clear() {
        this.myModel.setName(null);
        this.myModel.setProfession(null);
    }

    @ActionMethod(value="loadA")
    private void loadA() {
        this.myModel.loadVersionA();
    }

    @ActionMethod(value="loadB")
    private void loadB() {
        this.myModel.loadVersionB();
    }
}

