/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples.validation.context;

import io.datafx.controller.FXMLController;
import io.datafx.controller.validation.ValidatorFX;
import io.datafx.controller.validation.context.Validator;
import io.datafx.controller.validation.event.ValidationFinishedEvent;
import io.datafx.controller.validation.event.ValidationFinishedHandler;
import io.datafx.samples.validation.ValidateableDataModel;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;

@FXMLController(value="view.fxml")
public class ValidationController {
    @FXML
    private Button validateButton;
    @FXML
    private TextField nameField;
    @FXML
    private TextArea descriptionField;
    @Valid
    private ValidateableDataModel model = new ValidateableDataModel();
    @Validator
    private ValidatorFX<ValidationController> validator;

    @PostConstruct
    public void init() {
        this.nameField.textProperty().bindBidirectional((Property)this.model.nameProperty());
        this.descriptionField.textProperty().bindBidirectional((Property)this.model.descriptionProperty());
        this.validator.setOnValidationFinished((ValidationFinishedHandler)new ValidationFinishedHandler<ValidationController>(){

            public void handle(ValidationFinishedEvent<ValidationController> event) {
                for (ConstraintViolation violation : event.getViolations()) {
                    System.out.println(violation.getMessage());
                }
            }
        });
        this.validateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                ValidationController.this.validator.validateAllProperties(new Class[0]);
            }
        });
    }
}

