/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples;

import io.datafx.io.DataReader;
import io.datafx.io.FileSource;
import io.datafx.io.converter.InputStreamConverter;
import io.datafx.io.converter.XmlConverter;
import io.datafx.provider.ListDataProvider;
import io.datafx.samples.Book;
import io.datafx.samples.FileXmlSingleSample;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class FileXmlListSample {
    public Node getContent(Scene scene) throws IOException {
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.setPrefWidth(scene.getWidth());
        tabPane.setPrefHeight(scene.getHeight());
        tabPane.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        tabPane.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        Tab localTab = new Tab("local");
        this.buildLocalTab(localTab);
        tabPane.getTabs().add((Object)localTab);
        Tab networkTab = new Tab("network");
        this.buildNetworkTab(networkTab);
        tabPane.getTabs().add((Object)networkTab);
        return tabPane;
    }

    private void buildLocalTab(Tab tab) throws IOException {
        try {
            URL resource = this.getClass().getResource("manybooks.xml");
            XmlConverter converter = new XmlConverter("book", Book.class);
            FileSource dr = new FileSource(new File(resource.getFile()), (InputStreamConverter)converter);
            ListDataProvider sodp = new ListDataProvider((DataReader)dr);
            sodp.retrieve();
            ListProperty op = sodp.getData();
            ListView lv = new ListView((ObservableList)op.get());
            tab.setContent((Node)lv);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileXmlSingleSample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void buildNetworkTab(Tab tab) {
    }
}

