/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples.validation.property;

import io.datafx.controller.ViewController;
import io.datafx.controller.validation.ValidatorFX;
import io.datafx.controller.validation.context.Validator;
import io.datafx.controller.validation.event.ValidationFinishedEvent;
import io.datafx.controller.validation.event.ValidationFinishedHandler;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.NotNull;

@ViewController(value="view.fxml")
public class PropertyValidationController {
    @FXML
    private Button validateButton;
    @FXML
    private TextField nameField;
    @FXML
    private TextArea descriptionField;
    @NotNull
    private StringProperty name = new SimpleStringProperty();
    @NotNull
    private StringProperty description = new SimpleStringProperty();
    @Validator
    private ValidatorFX<PropertyValidationController> validator;

    @PostConstruct
    public void init() {
        this.nameField.textProperty().bindBidirectional((Property)this.name);
        this.descriptionField.textProperty().bindBidirectional((Property)this.description);
        this.validator.setOnValidationFinished((ValidationFinishedHandler)new ValidationFinishedHandler<PropertyValidationController>(){

            public void handle(ValidationFinishedEvent<PropertyValidationController> event) {
                for (ConstraintViolation violation : event.getViolations()) {
                    System.out.println(violation.getMessage());
                }
            }
        });
        this.validateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                PropertyValidationController.this.validator.validateAllProperties(new Class[0]);
            }
        });
    }
}

