/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples.jpacrud;

import io.datafx.controller.ViewController;
import io.datafx.controller.flow.action.ActionMethod;
import io.datafx.controller.flow.action.ActionTrigger;
import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.crud.CrudListProperty;
import io.datafx.crud.CrudService;
import io.datafx.crud.table.TableColumnFactory;
import io.datafx.crud.util.EntityWithId;
import io.datafx.samples.jpacrud.TestEntity;
import io.datafx.samples.jpacrud.TestEntityCrudService;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

@ViewController(value="master.fxml", title="CRUD")
public class TestEntityMasterController {
    @FXML
    TableView<TestEntity> dataTable;
    @FXML
    @ActionTrigger(value="addAction")
    private Button addButton;
    @FXML
    @ActionTrigger(value="reloadAction")
    private Button reloadButton;
    @FXML
    @ActionTrigger(value="removeAction")
    private Button removeButton;
    @Inject
    private TestEntityCrudService crudService;
    private CrudListProperty<TestEntity, Long> data;
    private BooleanProperty disableUiProperty;

    @PostConstruct
    public void init() {
        this.initDisableUiProperty();
        this.data = new CrudListProperty((CrudService)this.crudService);
        this.dataTable.getColumns().setAll((Collection)TableColumnFactory.createColumns(TestEntity.class));
        this.dataTable.setItems(this.data.getImmutableEntityList());
    }

    @ActionMethod(value="addAction")
    public void onAddAction() {
        this.data.addAndSave((EntityWithId)new TestEntity("Entity"));
    }

    @ActionMethod(value="reloadAction")
    public void onReloadAction() {
        this.disableUiProperty.setValue(Boolean.valueOf(true));
        ConcurrentUtils.then((Worker)this.data.reload(), e -> this.disableUiProperty.setValue(Boolean.valueOf(false)));
    }

    @ActionMethod(value="removeAction")
    public void onRemoveAction() {
        this.disableUiProperty.setValue(Boolean.valueOf(true));
        ConcurrentUtils.then((Worker)this.data.get(this.dataTable.getSelectionModel().getSelectedIndex()).delete(), e -> this.disableUiProperty.setValue(Boolean.valueOf(false)));
    }

    private void initDisableUiProperty() {
        this.disableUiProperty = new SimpleBooleanProperty(false);
        this.addButton.disableProperty().bind((ObservableValue)this.disableUiProperty);
        this.reloadButton.disableProperty().bind((ObservableValue)this.disableUiProperty);
        this.removeButton.disableProperty().bind((ObservableValue)this.disableUiProperty.or((ObservableBooleanValue)this.dataTable.getSelectionModel().selectedIndexProperty().lessThan(0)));
    }
}

