/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples;

import io.datafx.io.DataReader;
import io.datafx.io.FileSource;
import io.datafx.io.converter.InputStreamConverter;
import io.datafx.io.converter.JsonConverter;
import io.datafx.provider.ObjectDataProvider;
import io.datafx.provider.ObjectDataProviderBuilder;
import io.datafx.samples.FileXmlSingleSample;
import io.datafx.samples.Response;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class NestedListSample {
    public Node getContent(Scene scene) throws IOException {
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.setPrefWidth(scene.getWidth());
        tabPane.setPrefHeight(scene.getHeight());
        tabPane.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        tabPane.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        Tab localTab = new Tab("local");
        this.buildLocalTab(localTab);
        tabPane.getTabs().add((Object)localTab);
        Tab networkTab = new Tab("network");
        this.buildNetworkTab(networkTab);
        tabPane.getTabs().add((Object)networkTab);
        return tabPane;
    }

    private void buildLocalTab(Tab tab) throws IOException {
        try {
            final ListView lv = new ListView();
            URL resource = this.getClass().getResource("responsewithlist.json");
            JsonConverter converter = new JsonConverter(null, Response.class);
            FileSource dr = new FileSource(new File(resource.getFile()), (InputStreamConverter)converter);
            ObjectDataProviderBuilder odpb = ObjectDataProviderBuilder.create();
            SimpleObjectProperty resultProperty = new SimpleObjectProperty();
            odpb.dataReader((DataReader)dr).resultProperty((ObjectProperty)resultProperty);
            ObjectDataProvider provider = odpb.build();
            Worker worker = provider.retrieve();
            worker.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>((ObjectProperty)resultProperty){
                final /* synthetic */ ObjectProperty val$resultProperty;
                {
                    this.val$resultProperty = objectProperty;
                }

                public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                    if (newValue.equals((Object)Worker.State.SUCCEEDED)) {
                        lv.setItems(((Response)this.val$resultProperty.get()).getDetails());
                    }
                }
            });
            tab.setContent((Node)lv);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileXmlSingleSample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void buildNetworkTab(Tab tab) {
    }
}

