/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.samples;

import io.datafx.io.DataReader;
import io.datafx.io.JdbcSource;
import io.datafx.io.WritableDataReader;
import io.datafx.io.WriteBackHandler;
import io.datafx.io.converter.JdbcConverter;
import io.datafx.provider.ListDataProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class JdbcSample {
    private static Connection conn;
    private static final String dbURL = "jdbc:derby:memory:myDB;create=true";

    public Node getContent(Scene scene) {
        JdbcSample.createDatabase();
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.setPrefWidth(scene.getWidth());
        tabPane.setPrefHeight(scene.getHeight());
        tabPane.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        tabPane.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        Tab localTab = new Tab("local");
        this.buildLocalTab(localTab);
        tabPane.getTabs().add((Object)localTab);
        return tabPane;
    }

    private void buildLocalTab(Tab tab) {
        try {
            JdbcConverter<Person> converter = new JdbcConverter<Person>(){

                public Person convertOneRow(ResultSet resultSet) {
                    try {
                        Person answer = new Person();
                        answer.setFirstName(resultSet.getString("firstName"));
                        answer.setLastName(resultSet.getString("lastName"));
                        answer.setCountry(resultSet.getString("country"));
                        return answer;
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(JdbcSample.class.getName()).log(Level.SEVERE, null, ex);
                        return null;
                    }
                }
            };
            JdbcSource dr = new JdbcSource(dbURL, (JdbcConverter)converter, "PERSON", new String[]{"firstName", "lastName", "country"});
            ListDataProvider lodp = new ListDataProvider((DataReader)dr);
            ObservableList myList = FXCollections.observableArrayList();
            lodp.setResultObservableList(myList);
            lodp.setWriteBackHandler((WriteBackHandler)new WriteBackHandler<Person>(){

                public WritableDataReader createDataSource(Person me) {
                    String statement = "UPDATE PERSON SET lastName='" + me.getLastName() + "' WHERE firstName='" + me.getFirstName() + "'";
                    JdbcSource dr = new JdbcSource(JdbcSample.dbURL, statement, null);
                    dr.setUpdateQuery(true);
                    System.out.println("Writeback called with statement " + statement);
                    return dr;
                }
            });
            lodp.retrieve();
            ListProperty op = lodp.getData();
            TableView tv = new TableView(myList);
            tv.setEditable(true);
            TableColumn firstNameCol = new TableColumn("First ViewColumn");
            firstNameCol.setCellValueFactory((Callback)new PropertyValueFactory("firstName"));
            TableColumn lastNameCol = new TableColumn("Last ViewColumn");
            lastNameCol.setCellValueFactory((Callback)new PropertyValueFactory("lastName"));
            lastNameCol.setCellFactory((Callback)new Callback<TableColumn<Person, String>, TableCell<Person, String>>(){

                public TableCell<Person, String> call(TableColumn<Person, String> p) {
                    return new TextFieldTableCell((StringConverter)new StringConverter<String>(){

                        public String toString(String t) {
                            return t;
                        }

                        public String fromString(String string) {
                            return string;
                        }
                    });
                }
            });
            lastNameCol.setEditable(true);
            lastNameCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Person, String>>(){

                public void handle(TableColumn.CellEditEvent<Person, String> t) {
                    Person person = (Person)t.getRowValue();
                    String nv = (String)t.getNewValue();
                    person.setLastName(nv);
                }
            });
            TableColumn countryCol = new TableColumn("Country");
            countryCol.setCellValueFactory((Callback)new PropertyValueFactory("country"));
            tv.getColumns().setAll((Object[])new TableColumn[]{firstNameCol, lastNameCol, countryCol});
            tab.setContent((Node)tv);
        }
        catch (Exception ex) {
            Logger.getLogger(JdbcSample.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void createDatabase() {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            conn = DriverManager.getConnection(dbURL);
            conn.createStatement().execute("create table PERSON (FIRSTNAME varchar(255), LASTNAME varchar(255), COUNTRY varchar(255))");
            conn.createStatement().execute("INSERT INTO PERSON values ('Jonathan', 'Giles', 'New Zealand')");
            conn.createStatement().execute("INSERT INTO PERSON values ('Johan', 'Vos', 'Belgium')");
            conn.createStatement().execute("INSERT INTO PERSON values ('Hendrik', 'Ebbers', 'Germany')");
        }
        catch (Exception except) {
            except.printStackTrace();
        }
    }

    public class Person {
        private StringProperty firstName = new SimpleStringProperty();
        private StringProperty lastName = new SimpleStringProperty();
        private String country;

        public void setFirstName(String value) {
            this.firstNameProperty().set((Object)value);
        }

        public String getFirstName() {
            return (String)this.firstNameProperty().get();
        }

        public StringProperty firstNameProperty() {
            if (this.firstName == null) {
                this.firstName = new SimpleStringProperty((Object)this, "firstName");
            }
            return this.firstName;
        }

        public String getLastName() {
            return (String)this.lastName.get();
        }

        public void setLastName(String lastName) {
            this.lastName.set((Object)lastName);
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }
    }
}

