/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.injection;

import io.datafx.controller.context.AbstractContext;
import io.datafx.controller.context.ViewContext;
import io.datafx.controller.injection.DependendContext;
import io.datafx.controller.injection.provider.ContextProvider;
import io.datafx.core.DataFXUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ServiceLoader;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javax.inject.Inject;

public class InjectionHandler<U> {
    private static final DependendContext DEPENDEND_CONTEXT = new DependendContext();
    private ViewContext<U> viewContext;

    public InjectionHandler(ViewContext<U> viewContext) {
        this.viewContext = viewContext;
    }

    private <T> T registerNewInstance(Class<T> propertyClass, AbstractContext context) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        for (Constructor<?> constructor : propertyClass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            T instance = propertyClass.newInstance();
            context.register(instance);
            this.injectAllSupportedFields(instance);
            return instance;
        }
        throw new RuntimeException("No default constructor present!");
    }

    public <T> T createProxy(final Class<T> propertyClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        AbstractContext context = this.getContextForClass(propertyClass);
        Object registeredObject = context.getRegisteredObject(propertyClass);
        if (registeredObject == null) {
            registeredObject = this.registerNewInstance(propertyClass, context);
        }
        final Object innerObject = registeredObject;
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(propertyClass);
        MethodHandler handler = new MethodHandler(){

            public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                AbstractContext context = InjectionHandler.this.getContextForClass(propertyClass);
                if (context.getRegisteredObject(propertyClass) == null) {
                    InjectionHandler.this.registerNewInstance(propertyClass, context);
                }
                return thisMethod.invoke(innerObject, args);
            }
        };
        return (T)factory.create(new Class[0], new Object[0], handler);
    }

    private <T> void injectAllSupportedFields(T bean) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Class<?> cls = bean.getClass();
        for (Field field : DataFXUtils.getInheritedPrivateFields(cls)) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            DataFXUtils.setPrivileged((Field)field, bean, this.createProxy(field.getType()));
        }
    }

    private AbstractContext getContextForClass(Class<?> cls) {
        ServiceLoader<ContextProvider> contextProvidersLoader = ServiceLoader.load(ContextProvider.class);
        for (ContextProvider provider : contextProvidersLoader) {
            if (!cls.isAnnotationPresent(provider.supportedAnnotation())) continue;
            return provider.getContext(this.viewContext);
        }
        return DEPENDEND_CONTEXT;
    }
}

