/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.context;

import io.datafx.controller.context.ViewContext;
import io.datafx.controller.context.resource.AnnotatedControllerResourceType;
import io.datafx.controller.context.resource.ControllerResourceConsumer;
import io.datafx.core.DataFXUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class ContextResolver<U> {
    private ViewContext<U> context;

    public ContextResolver(ViewContext<U> context) {
        this.context = context;
    }

    public void injectResources(Object object) {
        List<AnnotatedControllerResourceType> allResourceTypes = this.getAnnotatedControllerResourceTypes();
        List<ControllerResourceConsumer> resourceConsumers = this.getControllerResourceConsumer();
        Class<?> cls = object.getClass();
        for (Field field : DataFXUtils.getInheritedPrivateFields(cls)) {
            List<Annotation> fieldAnnotations = Arrays.asList(field.getAnnotations());
            if (fieldAnnotations == null || fieldAnnotations.isEmpty()) continue;
            boolean injected = false;
            for (AnnotatedControllerResourceType currentResourceType : allResourceTypes) {
                if (field.getAnnotation(currentResourceType.getSupportedAnnotation()) == null) continue;
                if (injected) {
                    throw new RuntimeException("TODO: double injection of field");
                }
                DataFXUtils.setPrivileged((Field)field, (Object)object, currentResourceType.getResource(field.getAnnotation(currentResourceType.getSupportedAnnotation()), field.getType(), this.context));
                injected = true;
            }
            for (ControllerResourceConsumer consumer : resourceConsumers) {
                if (field.getAnnotation(consumer.getSupportedAnnotation()) == null) continue;
                consumer.consumeResource(field.getAnnotation(consumer.getSupportedAnnotation()), DataFXUtils.getPrivileged((Field)field, (Object)object), this.context);
            }
        }
    }

    private List<AnnotatedControllerResourceType> getAnnotatedControllerResourceTypes() {
        ServiceLoader<AnnotatedControllerResourceType> serviceLoader = ServiceLoader.load(AnnotatedControllerResourceType.class);
        Iterator<AnnotatedControllerResourceType> allResourceTypesIterator = serviceLoader.iterator();
        ArrayList supportedAnnotations = new ArrayList();
        ArrayList<AnnotatedControllerResourceType> allResourceTypes = new ArrayList<AnnotatedControllerResourceType>();
        while (allResourceTypesIterator.hasNext()) {
            AnnotatedControllerResourceType currentResourceType = allResourceTypesIterator.next();
            if (supportedAnnotations.contains(currentResourceType.getSupportedAnnotation())) {
                throw new RuntimeException("TODO: Annotation wird doppelt belegt");
            }
            supportedAnnotations.add(currentResourceType.getSupportedAnnotation());
            allResourceTypes.add(currentResourceType);
        }
        return allResourceTypes;
    }

    private List<ControllerResourceConsumer> getControllerResourceConsumer() {
        ServiceLoader<ControllerResourceConsumer> serviceLoader = ServiceLoader.load(ControllerResourceConsumer.class);
        Iterator<ControllerResourceConsumer> iterator = serviceLoader.iterator();
        ArrayList<ControllerResourceConsumer> ret = new ArrayList<ControllerResourceConsumer>();
        while (iterator.hasNext()) {
            ret.add(iterator.next());
        }
        return ret;
    }

    public <T> T createInstanceWithInjections(Class<T> cls) throws InstantiationException, IllegalAccessException {
        T instance = cls.newInstance();
        this.injectResources(instance);
        return instance;
    }
}

