/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller;

import io.datafx.controller.FXMLController;
import io.datafx.controller.FxmlLoadException;
import io.datafx.controller.ViewConfiguration;
import io.datafx.controller.context.ViewContext;
import io.datafx.controller.context.ViewMetadata;
import io.datafx.core.DataFXUtils;
import io.datafx.core.ExceptionHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;

public class ViewFactory {
    private static ViewFactory instance;

    private ViewFactory() {
    }

    public static synchronized ViewFactory getInstance() {
        if (instance == null) {
            instance = new ViewFactory();
        }
        return instance;
    }

    public <T> ViewContext<T> createByController(Class<T> controllerClass) throws FxmlLoadException {
        return this.createByController(controllerClass, null);
    }

    public <T> ViewContext<T> createByController(Class<T> controllerClass, String fxmlName) throws FxmlLoadException {
        return this.createByController(controllerClass, fxmlName, new ViewConfiguration(), new Object[0]);
    }

    public <T> ViewContext<T> createByController(Class<T> controllerClass, String fxmlName, ViewConfiguration viewConfiguration, Object ... viewContextResources) throws FxmlLoadException {
        try {
            T controller = controllerClass.newInstance();
            ViewMetadata metadata = new ViewMetadata();
            FXMLController controllerAnnotation = controllerClass.getAnnotation(FXMLController.class);
            if (controllerAnnotation != null && !controllerAnnotation.title().isEmpty()) {
                metadata.setTitle(controllerAnnotation.title());
            }
            if (controllerAnnotation != null && !controllerAnnotation.iconPath().isEmpty()) {
                metadata.setGraphic((Node)new ImageView(controllerClass.getResource(controllerAnnotation.iconPath()).toExternalForm()));
            }
            FXMLLoader loader = this.createLoader(controller, fxmlName, viewConfiguration);
            Node viewNode = (Node)loader.load();
            ViewContext<T> context = new ViewContext<T>(viewNode, controller, metadata, viewConfiguration, viewContextResources);
            context.register(controller);
            context.register("controller", controller);
            this.injectFXMLNodes(context);
            context.getResolver().injectResources(controller);
            for (Method method : controller.getClass().getMethods()) {
                if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                method.invoke(controller, new Object[0]);
            }
            return context;
        }
        catch (Exception e) {
            throw new FxmlLoadException(e);
        }
    }

    public void showInStage(Stage stage, Class<?> controllerClass) throws FxmlLoadException {
        Scene myScene = new Scene((Parent)this.createByController(controllerClass).getRootNode());
        stage.setScene(myScene);
        stage.show();
    }

    private FXMLLoader createLoader(Object controller, String fxmlName, ViewConfiguration viewConfiguration) throws FxmlLoadException {
        Class<?> controllerClass = controller.getClass();
        String foundFxmlName = this.getFxmlName(controllerClass);
        if (fxmlName != null) {
            foundFxmlName = fxmlName;
        }
        if (foundFxmlName == null) {
            throw new FxmlLoadException("No FXML File specified!");
        }
        FXMLLoader fxmlLoader = new FXMLLoader(controllerClass.getResource(foundFxmlName));
        fxmlLoader.setBuilderFactory(viewConfiguration.getBuilderFactory());
        fxmlLoader.setCharset(viewConfiguration.getCharset());
        fxmlLoader.setResources(viewConfiguration.getResources());
        fxmlLoader.setController(controller);
        fxmlLoader.setControllerFactory(c -> controller);
        return fxmlLoader;
    }

    private String getFxmlName(Class<?> controllerClass) {
        FXMLController controllerAnnotation;
        String nameByController;
        String foundFxmlName = null;
        if (controllerClass.getSimpleName().endsWith("Controller") && DataFXUtils.canAccess(controllerClass, (String)(nameByController = controllerClass.getSimpleName().substring(0, controllerClass.getSimpleName().length() - "Controller".length()) + ".fxml"))) {
            foundFxmlName = nameByController;
        }
        if ((controllerAnnotation = controllerClass.getAnnotation(FXMLController.class)) != null) {
            foundFxmlName = controllerAnnotation.value();
        }
        return foundFxmlName;
    }

    public <T> Tab createTab(Class<T> controllerClass) throws FxmlLoadException {
        return this.createTab(this.createByController(controllerClass));
    }

    public <T> Tab createTab(Class<T> controllerClass, ExceptionHandler exceptionHandler) throws FxmlLoadException {
        return this.createTab(this.createByController(controllerClass), exceptionHandler);
    }

    public <T> Tab createTab(ViewContext<T> context) {
        return this.createTab(context, ExceptionHandler.getDefaultInstance());
    }

    public <T> Tab createTab(ViewContext<T> context, ExceptionHandler exceptionHandler) {
        Tab tab = new Tab();
        tab.textProperty().bind((ObservableValue)context.getMetadata().titleProperty());
        tab.graphicProperty().bind(context.getMetadata().graphicsProperty());
        tab.setOnClosed(e -> {
            try {
                context.destroy();
            }
            catch (Exception exception) {
                exceptionHandler.setException((Throwable)exception);
            }
        });
        tab.setContent(context.getRootNode());
        return tab;
    }

    private <T> void injectFXMLNodes(ViewContext<T> context) {
        T controller = context.getController();
        Node n = context.getRootNode();
        List fields = DataFXUtils.getInheritedPrivateFields(controller.getClass());
        for (Field field : fields) {
            Node toInject;
            if (field.getAnnotation(FXML.class) == null || DataFXUtils.getPrivileged((Field)field, controller) != null || !Node.class.isAssignableFrom(field.getType()) || (toInject = n.lookup("#" + field.getName())) == null) continue;
            DataFXUtils.setPrivileged((Field)field, controller, (Object)toInject);
        }
    }
}

