/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.flow.container;

import io.datafx.controller.context.ViewContext;
import io.datafx.controller.flow.FlowContainer;
import io.datafx.controller.flow.container.ContainerAnimations;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class AnimatedFlowContainer
implements FlowContainer<StackPane> {
    private StackPane root = new StackPane();
    private Duration duration;
    private Function<AnimatedFlowContainer, List<KeyFrame>> animationProducer;
    private Timeline animation;
    private ImageView placeholder;

    public AnimatedFlowContainer() {
        this(Duration.millis((double)320.0));
    }

    public AnimatedFlowContainer(Duration duration) {
        this(duration, ContainerAnimations.FADE);
    }

    public AnimatedFlowContainer(Duration duration, ContainerAnimations animation) {
        this(duration, animation.getAnimationProducer());
    }

    public AnimatedFlowContainer(Duration duration, Function<AnimatedFlowContainer, List<KeyFrame>> animationProducer) {
        this.duration = duration;
        this.animationProducer = animationProducer;
        this.placeholder = new ImageView();
        this.placeholder.setPreserveRatio(true);
        this.placeholder.setSmooth(true);
    }

    @Override
    public <U> void setViewContext(ViewContext<U> context) {
        this.updatePlaceholder(context.getRootNode());
        if (this.animation != null) {
            this.animation.stop();
        }
        this.animation = new Timeline();
        this.animation.getKeyFrames().addAll((Collection)this.animationProducer.apply(this));
        this.animation.getKeyFrames().add((Object)new KeyFrame(this.duration, e -> this.clearPlaceholder(), new KeyValue[0]));
        this.animation.play();
    }

    public ImageView getPlaceholder() {
        return this.placeholder;
    }

    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public StackPane getView() {
        return this.root;
    }

    private void clearPlaceholder() {
        this.placeholder.setImage(null);
        this.placeholder.setVisible(false);
    }

    private void updatePlaceholder(Node newView) {
        if (this.root.getWidth() > 0.0 && this.root.getHeight() > 0.0) {
            WritableImage placeholderImage = this.root.snapshot(null, new WritableImage((int)this.root.getWidth(), (int)this.root.getHeight()));
            this.placeholder.setImage((Image)placeholderImage);
            this.placeholder.setFitWidth(placeholderImage.getWidth());
            this.placeholder.setFitHeight(placeholderImage.getHeight());
        } else {
            this.placeholder.setImage(null);
        }
        this.placeholder.setVisible(true);
        this.placeholder.setOpacity(1.0);
        this.root.getChildren().setAll((Object[])new Node[]{this.placeholder});
        this.root.getChildren().add((Object)newView);
        this.placeholder.toFront();
    }
}

