/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.flow.action;

import io.datafx.controller.flow.FlowException;
import io.datafx.controller.flow.FlowHandler;
import io.datafx.controller.flow.action.FlowAction;

public abstract class AbstractFlowTaskAction
implements FlowAction {
    private Class<? extends Runnable> runnableClass;
    private TaskFactory runnableFactory;

    public AbstractFlowTaskAction(Class<? extends Runnable> runnableClass) {
        this.runnableFactory = f -> (Runnable)f.getCurrentViewContext().getResolver().createInstanceWithInjections(runnableClass);
    }

    public AbstractFlowTaskAction(Runnable runnable) {
        this.runnableFactory = f -> runnable;
    }

    @Override
    public void handle(FlowHandler flowHandler, String actionId) throws FlowException {
        try {
            Runnable runnable = this.runnableFactory.create(flowHandler);
            this.execute(runnable);
        }
        catch (Exception e) {
            throw new FlowException(e);
        }
    }

    protected abstract void execute(Runnable var1) throws Exception;

    @FunctionalInterface
    public static interface TaskFactory {
        public Runnable create(FlowHandler var1) throws Exception;
    }
}

