/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.ejb;

import io.datafx.ejb.EjbLookup;
import io.datafx.ejb.EjbLookupConfiguration;
import io.datafx.ejb.EjbLookupConfigurationProvider;
import java.util.ServiceLoader;

public class EjbLookupFactory {
    public EjbLookup get(String name) {
        ServiceLoader<EjbLookupConfigurationProvider> loader = ServiceLoader.load(EjbLookupConfigurationProvider.class);
        for (EjbLookupConfigurationProvider provider : loader) {
            if (!this.isNameMatching(provider.getLookupName(), name)) continue;
            EjbLookupConfiguration configuration = provider.getConfiguration();
            EjbLookup lookup = configuration.createLookup();
            return lookup;
        }
        return null;
    }

    public boolean isNameMatching(String providerName, String name) {
        if (providerName == null && name == null) {
            return true;
        }
        if (providerName == null && name != null) {
            return name == "";
        }
        if (providerName != null && name == null) {
            return providerName == "";
        }
        return providerName.equals(name);
    }
}

