/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.ejb;

import io.datafx.ejb.EjbLookupConfiguration;
import io.datafx.ejb.JndiClassBinding;
import io.datafx.ejb.JndiClassBindingProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.ClassUtils;

public class EjbLookup {
    private Context context;
    private Hashtable contextEnvironment = new Hashtable();
    private Map<Class<?>, String> jndiMapping;
    private String contextId;
    private BooleanProperty unwrapEjbException;

    public EjbLookup(EjbLookupConfiguration configuration) {
        this.contextEnvironment.putAll(configuration.getContextEnvironment());
        this.contextId = configuration.getContextId();
        this.jndiMapping = new HashMap();
        ServiceLoader<JndiClassBindingProvider> loader = ServiceLoader.load(JndiClassBindingProvider.class);
        for (JndiClassBindingProvider provider : loader) {
            if (!this.matchContextId(provider.getContextId())) continue;
            List<JndiClassBinding<?>> namedBindings = provider.getBindings();
            for (JndiClassBinding<?> binding : namedBindings) {
                this.add(binding);
            }
        }
    }

    public BooleanProperty unwrapEjbExceptionProperty() {
        if (this.unwrapEjbException == null) {
            this.unwrapEjbException = new SimpleBooleanProperty(true);
        }
        return this.unwrapEjbException;
    }

    public boolean matchContextId(String id) {
        if (this.contextId == null && id == null) {
            return true;
        }
        if (this.contextId == null && id != null) {
            return id == "";
        }
        if (this.contextId != null && id == null) {
            return this.contextId == "";
        }
        return this.contextId.equals(id);
    }

    public void add(JndiClassBinding<?> binding) {
        Class<?> boundClass = binding.getBoundClass();
        String name = binding.getJndiPath();
        if (this.jndiMapping.containsKey(boundClass)) {
            throw new IllegalArgumentException("Class " + boundClass + " already registered.");
        }
        this.jndiMapping.put(boundClass, name);
    }

    public <T> T lookup(Class<T> namedObjectClass) throws NamingException {
        return this.lookupByJndi(this.getJndiPathForClass(namedObjectClass));
    }

    public <T> T lookupByJndi(String path) throws NamingException {
        final Object innerInstance = this.getContext().lookup(path);
        if (innerInstance != null) {
            List interfaces = ClassUtils.getAllInterfaces(innerInstance.getClass());
            Class[] clsList = interfaces.toArray(new Class[interfaces.size()]);
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), clsList, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        return method.invoke(innerInstance, args);
                    }
                    catch (EJBException e) {
                        if (EjbLookup.this.unwrapEjbException.get()) {
                            throw e.getCausedByException();
                        }
                        throw e;
                    }
                }
            });
        }
        return null;
    }

    private String getJndiPathForClass(Class<?> namedObjectClass) {
        return this.jndiMapping.get(namedObjectClass);
    }

    private Context getContext() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext(this.contextEnvironment);
        }
        return this.context;
    }
}

