/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.ejb.jboss;

import io.datafx.ejb.EjbLookupConfiguration;
import java.util.Hashtable;
import java.util.Properties;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;

public class JBossLookupConfiguration
extends EjbLookupConfiguration {
    public JBossLookupConfiguration(String contextId) {
        super(contextId);
        this.addToEnvironment(JBossLookupConfiguration.createDefaultContextEnvironment());
    }

    public JBossLookupConfiguration() {
        this.addToEnvironment(JBossLookupConfiguration.createDefaultContextEnvironment());
    }

    public JBossLookupConfiguration(String host, int port, String username, String password) {
        this(JBossLookupConfiguration.createDefaultEjbClientProperties(host, port, username, password), JBossLookupConfiguration.createDefaultContextEnvironment());
    }

    public JBossLookupConfiguration(Properties jbossEjbClientProperties) {
        PropertiesBasedEJBClientConfiguration ejbClientConfiguration = new PropertiesBasedEJBClientConfiguration(jbossEjbClientProperties);
        ConfigBasedEJBClientContextSelector ejbClientContextSelector = new ConfigBasedEJBClientContextSelector((EJBClientConfiguration)ejbClientConfiguration);
        EJBClientContext.setSelector((ContextSelector)ejbClientContextSelector);
    }

    public JBossLookupConfiguration(Properties jbossEjbClientProperties, Hashtable<?, ?> contextEnvironment) {
        this(jbossEjbClientProperties);
        this.addToEnvironment(contextEnvironment);
    }

    private static Hashtable<?, ?> createDefaultContextEnvironment() {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        return environment;
    }

    private static Properties createDefaultEjbClientProperties(String host, int port, String username, String password) {
        Properties jbossEjbClientProperties = new Properties();
        jbossEjbClientProperties.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
        jbossEjbClientProperties.put("remote.connections", "default");
        jbossEjbClientProperties.put("remote.connection.default.host", host);
        jbossEjbClientProperties.put("remote.connection.default.port", (Object)port);
        jbossEjbClientProperties.put("remote.connection.default.connect.options.org.xnio.Options.SASL_POLICY_NOANONYMOUS", "false");
        jbossEjbClientProperties.put("remote.connection.default.username", username);
        jbossEjbClientProperties.put("remote.connection.default.password", password);
        return jbossEjbClientProperties;
    }
}

