/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io;

import io.datafx.io.RestSource;
import io.datafx.io.ServerSentEventReader;
import io.datafx.provider.ObjectDataProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;

public class SSERestSource<T>
extends RestSource<T>
implements ServerSentEventReader<T> {
    private BufferedReader br;
    private T answer;
    private final Map<String, Field> observableFields = new HashMap<String, Field>();
    private final Map<String, Field> observableListFields = new HashMap<String, Field>();

    @Override
    public T get() {
        if (!this.requestMade) {
            try {
                InputStream is = this.createInputStream();
                this.br = new BufferedReader(new InputStreamReader(is));
                this.answer = this.processLine(this.br);
                this.checkObservableFields(this.answer);
                return this.answer;
            }
            catch (IOException ex) {
                Logger.getLogger(SSERestSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private T processLine(BufferedReader br) throws IOException {
        String line = br.readLine();
        while (line.isEmpty()) {
            line = br.readLine().trim();
        }
        if (line.startsWith("data:")) {
            String data = line.substring(5);
            this.getConverter().initialize(new ByteArrayInputStream(data.getBytes()));
            Object updated = this.getConverter().get();
            return updated;
        }
        return null;
    }

    @Override
    public void keepReading() {
        try {
            T updated = this.processLine(this.br);
            while (updated != null) {
                updated = this.processLine(this.br);
                this.updateFields(updated);
            }
            Object t = this.getConverter().get();
        }
        catch (IOException ex) {
            Logger.getLogger(SSERestSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateFields(final T newValues) {
        for (final Field field : this.observableFields.values()) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            final ObservableValue val = (ObservableValue)field.get(newValues);
                            final WritableValue obs = (WritableValue)field.get(SSERestSource.this.answer);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        obs.setValue(val.getValue());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            Logger.getLogger(SSERestSource.class.getName()).log(Level.SEVERE, null, ex);
                            ex.printStackTrace();
                        }
                        return null;
                    }
                });
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(SSERestSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (final Field field : this.observableListFields.values()) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            final ObservableList val = (ObservableList)field.get(newValues);
                            final ObservableList obs = (ObservableList)field.get(SSERestSource.this.answer);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        obs.setAll((Collection)val);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            Logger.getLogger(SSERestSource.class.getName()).log(Level.SEVERE, null, ex);
                            ex.printStackTrace();
                        }
                        return null;
                    }
                });
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(SSERestSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void checkObservableFields(final T target) {
        Field[] fields;
        Class<?> c = target.getClass();
        for (final Field field : fields = c.getDeclaredFields()) {
            Class<?> clazz = field.getType();
            if (ObservableValue.class.isAssignableFrom(clazz)) {
                try {
                    Observable observable = AccessController.doPrivileged(new PrivilegedAction<Observable>(){

                        @Override
                        public Observable run() {
                            try {
                                field.setAccessible(true);
                                Object f = field.get(target);
                                Observable answer = (Observable)f;
                                return answer;
                            }
                            catch (IllegalArgumentException ex) {
                                Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            catch (IllegalAccessException ex) {
                                Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            return null;
                        }
                    });
                    if (observable != null) {
                        this.observableFields.put(field.getName(), field);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!ObservableList.class.isAssignableFrom(clazz)) continue;
            try {
                ObservableList observableList = AccessController.doPrivileged(new PrivilegedAction<ObservableList>(){

                    @Override
                    public ObservableList run() {
                        try {
                            field.setAccessible(true);
                            Object f = field.get(target);
                            ObservableList answer = (ObservableList)f;
                            return answer;
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IllegalAccessException ex) {
                            Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        return null;
                    }
                });
                if (observableList == null) continue;
                this.observableListFields.put(field.getName(), field);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

