/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io;

import io.datafx.io.AbstractDataReader;
import io.datafx.io.WritableDataReader;
import io.datafx.io.converter.JdbcConverter;
import io.datafx.io.converter.JdbcDataSourceUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcSource<T>
extends AbstractDataReader<T>
implements WritableDataReader<T> {
    private final String sqlStatement;
    private final JdbcConverter<T> converter;
    private boolean connectionCreated;
    private boolean lastResult;
    private ResultSet resultSet;
    private boolean updateQuery = false;
    private JdbcConnectionFactory connectionFactory;

    public JdbcSource(String jdbcUrl, JdbcConverter<T> converter, String table, String ... cols) {
        this(jdbcUrl, JdbcDataSourceUtil.createSelectStatement(table, cols), converter);
    }

    public JdbcSource(final String jdbcUrl, String selectStatement, JdbcConverter<T> converter) {
        this(new JdbcConnectionFactory(){

            @Override
            public Connection getConnection() throws SQLException {
                return DriverManager.getConnection(jdbcUrl);
            }
        }, selectStatement, converter);
    }

    public JdbcSource(Connection connection, JdbcConverter<T> converter, String table, String ... cols) {
        this(connection, JdbcDataSourceUtil.createSelectStatement(table, cols), converter);
    }

    public JdbcSource(final Connection connection, String selectStatement, JdbcConverter<T> converter) {
        this(new JdbcConnectionFactory(){

            @Override
            public Connection getConnection() throws SQLException {
                return connection;
            }
        }, selectStatement, converter);
    }

    private JdbcSource(JdbcConnectionFactory connectionFactory, String selectStatement, JdbcConverter<T> converter) {
        this.connectionFactory = connectionFactory;
        this.sqlStatement = selectStatement;
        this.converter = converter;
    }

    public void setUpdateQuery(boolean b) {
        this.updateQuery = b;
    }

    private synchronized void createConnection() {
        if (this.connectionCreated) {
            return;
        }
        Connection connection = null;
        try {
            Statement query;
            connection = this.connectionFactory.getConnection();
            if (this.updateQuery) {
                System.out.println("updatequery");
                query = connection.createStatement();
            } else {
                System.out.println("regularquery");
                query = connection.createStatement(1003, 1007);
            }
            if (this.updateQuery) {
                query.executeUpdate(this.sqlStatement);
            } else {
                this.resultSet = query.executeQuery(this.sqlStatement);
                this.lastResult = this.resultSet.next();
                this.converter.initialize(this.resultSet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connectionCreated = true;
    }

    @Override
    public void writeBack() {
        try {
            Connection connection = this.connectionFactory.getConnection();
            Statement query = connection.createStatement();
            query.executeUpdate(this.sqlStatement);
        }
        catch (SQLException ex) {
            Logger.getLogger(JdbcSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public T get() {
        if (!this.connectionCreated) {
            this.createConnection();
        }
        if (this.converter != null) {
            return this.converter.get();
        }
        return null;
    }

    @Override
    public boolean next() {
        if (!this.connectionCreated) {
            this.createConnection();
        }
        boolean answer = this.converter.next();
        return answer;
    }

    private static interface JdbcConnectionFactory {
        public Connection getConnection() throws SQLException;
    }
}

