/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.provider;

import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.PublishingTask;
import io.datafx.io.DataReader;
import io.datafx.io.WritableDataReader;
import io.datafx.io.WriteBackHandler;
import io.datafx.io.WriteBackListProvider;
import io.datafx.io.WriteBackProvider;
import io.datafx.io.WriteTransient;
import io.datafx.provider.DataProvider;
import io.datafx.provider.ObjectDataProvider;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;

public class ListDataProvider<T>
implements DataProvider<ObservableList<T>>,
WriteBackProvider<T>,
WriteBackListProvider<T> {
    private ListProperty<T> listWrapper = new SimpleListProperty();
    private ObservableList<T> observableList;
    private DataReader<T> reader;
    private Executor executor;
    private WriteBackHandler<T> writeBackHandler;
    private WriteBackHandler<T> entryAddedHandler;
    static final Map<ObservableList, ListChangeListener> addListeners = new HashMap<ObservableList, ListChangeListener>();
    static final List myListeners2 = new LinkedList();

    public ListDataProvider() {
        this(null, null, null);
    }

    public ListDataProvider(DataReader<T> reader) {
        this(reader, null, null);
    }

    public ListDataProvider(DataReader<T> reader, Executor executor, ObservableList<T> existingList) {
        this.reader = reader;
        this.executor = executor;
        this.observableList = existingList != null ? existingList : FXCollections.observableArrayList();
        this.listWrapper.setValue(this.observableList);
    }

    public void setResultObservableList(ObservableList<T> ol) {
        this.observableList = ol;
        this.listWrapper.setValue(this.observableList);
    }

    public void setDataReader(DataReader<T> reader) {
        this.reader = reader;
    }

    public DataReader<T> getDataReader() {
        return this.reader;
    }

    @Override
    public Worker<ObservableList<T>> retrieve() {
        Service<ObservableList<T>> retriever = this.createService(this.observableList);
        return ConcurrentUtils.executeService((Executor)this.executor, retriever);
    }

    protected Service<ObservableList<T>> createService(final ObservableList<T> value) {
        return new Service<ObservableList<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Task<ObservableList<T>> createTask() {
                ListChangeListener existingListener = null;
                if (ListDataProvider.this.entryAddedHandler != null) {
                    Map<ObservableList, ListChangeListener> map = addListeners;
                    synchronized (map) {
                        Set<Map.Entry<ObservableList, ListChangeListener>> entrySet = addListeners.entrySet();
                        for (Map.Entry<ObservableList, ListChangeListener> entry : entrySet) {
                            if (!entry.getKey().equals(value)) continue;
                            existingListener = entry.getValue();
                        }
                        if (existingListener != null) {
                            value.removeListener(existingListener);
                        }
                    }
                }
                Task task = ListDataProvider.this.createReceiverTask(value);
                final ListChangeListener myListener = existingListener;
                task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(WorkerStateEvent arg0) {
                        if (ListDataProvider.this.entryAddedHandler != null) {
                            if (myListener != null) {
                                value.addListener(myListener);
                            } else {
                                ListChangeListener localListener = new ListChangeListener<T>(){

                                    public void onChanged(final ListChangeListener.Change<? extends T> change) {
                                        while (change.next()) {
                                            Service service = new Service(){

                                                protected Task createTask() {
                                                    Task task = new Task(){

                                                        protected Object call() throws Exception {
                                                            List addedSubList = change.getAddedSubList();
                                                            for (Object entry : addedSubList) {
                                                                WritableDataReader dataReader = ListDataProvider.this.entryAddedHandler.createDataSource(entry);
                                                                dataReader.writeBack();
                                                            }
                                                            return addedSubList;
                                                        }
                                                    };
                                                    return task;
                                                }
                                            };
                                            if (ListDataProvider.this.executor != null) {
                                                service.setExecutor(ListDataProvider.this.executor);
                                            }
                                            service.start();
                                        }
                                    }
                                };
                                Map<ObservableList, ListChangeListener> map = addListeners;
                                synchronized (map) {
                                    addListeners.put(value, localListener);
                                    value.addListener(localListener);
                                }
                            }
                        }
                    }
                });
                return task;
            }
        };
    }

    protected PublishingTask<T> createPublishingReceiverTask(ObservableList myResult) {
        PublishingTask answer = new PublishingTask<T>(myResult){

            protected void callTask() throws Exception {
                while (ListDataProvider.this.getDataReader().next()) {
                    Object entry = ListDataProvider.this.getDataReader().get();
                    this.publish(new Object[]{entry});
                    if (ListDataProvider.this.writeBackHandler == null) continue;
                    ListDataProvider.this.checkProperties(entry);
                }
            }
        };
        return answer;
    }

    protected final Task<ObservableList<T>> createReceiverTask(ObservableList myResult) {
        PublishingTask<T> task = this.createPublishingReceiverTask(myResult);
        return task;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public ListProperty<T> getData() {
        return this.listWrapper;
    }

    @Override
    public void setAddEntryHandler(WriteBackHandler<T> handler) {
        this.entryAddedHandler = handler;
    }

    @Override
    public void setWriteBackHandler(WriteBackHandler<T> handler) {
        this.writeBackHandler = handler;
    }

    private void checkProperties(final T target) {
        Field[] fields;
        Class<?> c = target.getClass();
        for (final Field field : fields = c.getDeclaredFields()) {
            Class<?> clazz = field.getType();
            if (!Observable.class.isAssignableFrom(clazz) || field.getAnnotation(WriteTransient.class) != null) continue;
            try {
                Observable observable = AccessController.doPrivileged(new PrivilegedAction<Observable>(){

                    @Override
                    public Observable run() {
                        try {
                            field.setAccessible(true);
                            Object f = field.get(target);
                            Observable answer = (Observable)f;
                            return answer;
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IllegalAccessException ex) {
                            Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        return null;
                    }
                });
                if (observable == null) continue;
                observable.addListener(new InvalidationListener(){

                    public void invalidated(final Observable o) {
                        Service service = new Service(){

                            protected Task createTask() {
                                Task task = new Task(){

                                    protected Object call() throws Exception {
                                        WritableDataReader reader = ListDataProvider.this.writeBackHandler.createDataSource(target);
                                        reader.writeBack();
                                        return o;
                                    }
                                };
                                return task;
                            }
                        };
                        if (ListDataProvider.this.executor != null) {
                            service.setExecutor(ListDataProvider.this.executor);
                        }
                        service.start();
                    }
                });
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ObjectDataProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void setResultProperty(Property<ObservableList<T>> result) {
        this.listWrapper = (ListProperty)result;
    }
}

