/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io.converter;

import io.datafx.io.converter.InputStreamConverter;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.xml.bind.annotation.XmlTransient;

public class JsonConverter<T>
extends InputStreamConverter<T> {
    private JsonStructure rootNode;
    private final String tag;
    private final Class<T> clazz;
    private final ObjectMapper<T> objectMapper;
    private Iterator<JsonValue> iterator;
    private static final Logger LOGGER = Logger.getLogger(JsonConverter.class.getName());

    public JsonConverter(Class<T> clazz) {
        this(null, clazz);
    }

    public JsonConverter(String tag, Class<T> clazz) {
        this.tag = tag;
        this.clazz = clazz;
        this.objectMapper = new ObjectMapper<T>(clazz);
    }

    @Override
    public void initialize(InputStream input) {
        JsonValue tagValue;
        JsonObject rootNodeObject;
        JsonReader reader = Json.createReader((InputStream)input);
        this.rootNode = reader.read();
        System.out.println("rootNode.toString() = " + this.rootNode.toString());
        if (this.rootNode.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray rootNodeArray = (JsonArray)this.rootNode;
            this.iterator = rootNodeArray.iterator();
        } else if (this.tag != null && this.rootNode.getValueType() == JsonValue.ValueType.OBJECT && (rootNodeObject = (JsonObject)this.rootNode).containsKey((Object)this.tag) && (tagValue = (JsonValue)rootNodeObject.get((Object)this.tag)).getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray rootNodeArray = (JsonArray)tagValue;
            this.iterator = rootNodeArray.iterator();
        }
    }

    @Override
    public T get() {
        Object item;
        LOGGER.log(Level.FINER, "getting json data, tag = {0}", this.tag);
        if (this.tag == null) {
            item = ((ObjectMapper)this.objectMapper).readValue((JsonValue)this.rootNode);
        } else {
            JsonValue next = this.iterator.next();
            item = ((ObjectMapper)this.objectMapper).readValue(next);
        }
        LOGGER.log(Level.FINER, "did read Object {0}", item);
        return (T)item;
    }

    @Override
    public boolean next() {
        if (this.tag == null) {
            return false;
        }
        return this.iterator.hasNext();
    }

    class ObjectMapper<T> {
        private final Class<T> clazz;
        private final Map<String, Method> settersMappedByPropertyName = new HashMap<String, Method>();

        public ObjectMapper(Class<T> clazz) {
            this.clazz = clazz;
            this.resolveProperties();
        }

        private synchronized void resolveProperties() {
            Method[] methods = this.clazz.getMethods();
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            HashMap<String, Method> getters = new HashMap<String, Method>();
            for (Method method : methods) {
                Method getter;
                String bareMethodName;
                String methodName = method.getName();
                if (Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.isAnnotationPresent(XmlTransient.class) && (methodName.matches("^get[A-Z].*") && !method.getReturnType().equals(Void.TYPE) || methodName.matches("^is[A-Z].*") && method.getReturnType().equals(Boolean.TYPE))) {
                    bareMethodName = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
                    getters.put(bareMethodName, method);
                }
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) || method.isAnnotationPresent(XmlTransient.class) || !methodName.matches("^set[A-Z].*") || (getter = (Method)getters.get(bareMethodName = methodName.substring(3))) == null) continue;
                String finalName = bareMethodName.substring(0, 1).toLowerCase();
                if (bareMethodName.length() > 1) {
                    finalName = finalName + bareMethodName.substring(1);
                }
                this.settersMappedByPropertyName.put(finalName, method);
            }
        }

        private T readValue(JsonValue value) {
            try {
                T t = this.clazz.newInstance();
                if (value.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject object = (JsonObject)value;
                    for (String property : this.settersMappedByPropertyName.keySet()) {
                        if (!object.containsKey((Object)property)) continue;
                        Method setter = this.settersMappedByPropertyName.get(property);
                        JsonValue propertyValue = (JsonValue)object.get((Object)property);
                        Object[] args = new Object[1];
                        switch (propertyValue.getValueType()) {
                            case NULL: {
                                args[0] = null;
                                break;
                            }
                            case FALSE: {
                                args[0] = Boolean.FALSE;
                                break;
                            }
                            case TRUE: {
                                args[0] = Boolean.TRUE;
                                break;
                            }
                            case STRING: {
                                JsonString stringProperty = (JsonString)propertyValue;
                                args[0] = stringProperty.getString();
                                break;
                            }
                            case NUMBER: {
                                String setterParameterTypeName;
                                JsonNumber numberProperty = (JsonNumber)propertyValue;
                                Class<?> setterParameterType = setter.getParameterTypes()[0];
                                if (setterParameterType.isArray()) break;
                                switch (setterParameterTypeName = setterParameterType.getName()) {
                                    case "byte": 
                                    case "java.lang.Byte": 
                                    case "int": 
                                    case "java.lang.Integer": 
                                    case "short": 
                                    case "java.lang.Short": {
                                        args[0] = numberProperty.intValue();
                                        break;
                                    }
                                    case "long": 
                                    case "java.lang.Long": {
                                        args[0] = numberProperty.longValue();
                                        break;
                                    }
                                    case "double": 
                                    case "java.lang.Double": {
                                        args[0] = numberProperty.doubleValue();
                                        break;
                                    }
                                    case "float": 
                                    case "java.lang.Float": {
                                        args[0] = Float.valueOf((float)numberProperty.doubleValue());
                                    }
                                }
                                break;
                            }
                            case ARRAY: {
                                JsonArray arrayProperty = (JsonArray)propertyValue;
                                Class<ObservableList> parameterType = setter.getParameterTypes()[0];
                                Object values = parameterType.isAssignableFrom(ObservableList.class) ? FXCollections.observableArrayList() : new ArrayList();
                                block41: for (int i = 0; i < arrayProperty.size(); ++i) {
                                    JsonValue arrayValue = (JsonValue)arrayProperty.get(i);
                                    switch (arrayValue.getValueType()) {
                                        case NULL: {
                                            values.add(null);
                                            continue block41;
                                        }
                                        case FALSE: {
                                            values.add(Boolean.FALSE);
                                            continue block41;
                                        }
                                        case TRUE: {
                                            values.add(Boolean.TRUE);
                                            continue block41;
                                        }
                                        case STRING: {
                                            JsonString stringArrayValue = (JsonString)arrayValue;
                                            values.add(stringArrayValue.getString());
                                            continue block41;
                                        }
                                        case NUMBER: {
                                            throw new UnsupportedOperationException("Arrays of numbers not yet supported.");
                                        }
                                        default: {
                                            throw new UnsupportedOperationException("Arrays or objects within arrays not yet supported.");
                                        }
                                    }
                                }
                                args[0] = values;
                                break;
                            }
                            case OBJECT: {
                                throw new UnsupportedOperationException("Nested Json Objects not yet supported.");
                            }
                        }
                        try {
                            setter.invoke(t, args);
                        }
                        catch (IllegalArgumentException | InvocationTargetException ex) {
                            Logger.getLogger(JsonConverter.class.getName()).log(Level.SEVERE, "Failed to call setter " + setter + " with value " + propertyValue, ex);
                        }
                    }
                }
                return t;
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(JsonConverter.class.getName()).log(Level.SEVERE, "Could not instantiate object of type " + this.clazz, ex);
                return null;
            }
        }
    }
}

