/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.io.converter;

import io.datafx.io.converter.InputStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXB;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlConverter<T>
extends InputStreamConverter<T> {
    private String tag;
    private Class<T> clazz;
    private NodeList childNodes;
    private int totalNodes;
    private int currentNode = 0;
    private boolean domCreated = false;
    private InputStream inputStream;

    public XmlConverter(Class<T> clazz) {
        this(null, clazz);
    }

    public XmlConverter(String tag, Class<T> clazz) {
        this.tag = tag;
        this.clazz = clazz;
    }

    @Override
    public T get() {
        if (this.tag == null) {
            if (this.currentNode == 0) {
                Object answer = JAXB.unmarshal((InputStream)this.inputStream, this.clazz);
                return (T)answer;
            }
            return null;
        }
        if (!this.domCreated) {
            throw new IllegalStateException("XmlConverter has not been initialized");
        }
        Node node = this.childNodes.item(this.currentNode);
        DOMSource source = new DOMSource(node);
        Object entry = JAXB.unmarshal((Source)source, this.clazz);
        System.out.println("entry retrieved: " + entry);
        ++this.currentNode;
        return (T)entry;
    }

    @Override
    public boolean next() {
        if (this.clazz == null) {
            if (this.currentNode == 0) {
                ++this.currentNode;
            }
            return this.currentNode == 0;
        }
        if (!this.domCreated) {
            throw new IllegalStateException("XmlConverter has not been initialized");
        }
        return this.currentNode < this.totalNodes;
    }

    @Override
    public synchronized void initialize(InputStream is) {
        this.inputStream = is;
        if (this.clazz == null) {
            return;
        }
        try {
            if (this.tag != null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(this.inputStream);
                this.childNodes = doc.getElementsByTagName(this.tag);
                this.totalNodes = this.childNodes.getLength();
                System.out.println("childnodes for tag " + this.tag + "= " + this.childNodes + " and length = " + this.totalNodes);
            } else {
                this.totalNodes = 1;
            }
            this.currentNode = 0;
            this.domCreated = true;
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XmlConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XmlConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

